/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.string;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lehjr.numina.common.math.Colour;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class StringUtils {
    public static final char[] smallSuffixes = new char[]{'m', '\u03bc', 'n', 'p', 'f', 'a', 'z', 'y'};
    public static final char[] bigSuffixes = new char[]{'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};

    public static String extractName(ResourceLocation resource) {
        return StringUtils.extractName(resource.toString());
    }

    public static String extractName(String filename) {
        int ix = Math.max(filename.lastIndexOf(47), Math.max(filename.lastIndexOf(92), filename.lastIndexOf(58))) + 1;
        return filename.substring(ix, filename.lastIndexOf(46)).trim();
    }

    public static String formatNumberShort(double number) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(2);
        format.applyPattern("##0.##E0");
        String[] exploded = format.format(number).split("E");
        String retval = exploded[0];
        if (retval.length() > 3) {
            retval = retval.charAt(3) == '.' ? retval.substring(0, 3) : retval.substring(0, 4);
        }
        if (exploded.length > 1) {
            int exponent = Integer.parseInt(exploded[1]);
            if (exponent > 0) {
                int index = exponent / 3 - 1;
                retval = index > bigSuffixes.length - 1 ? "Infinite M" : retval + bigSuffixes[index];
            } else if (exponent < 0) {
                int index = exponent / -3 - 1;
                retval = retval + smallSuffixes[index];
            }
        }
        return retval;
    }

    public static String formatNumberPercent(double number) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(2);
        format.applyPattern("##0.##");
        return format.format(number * 100.0);
    }

    public static String formatNumberFromUnits(double number, String units) {
        if (units.equals("%")) {
            return StringUtils.formatNumberPercent(number) + '%';
        }
        return StringUtils.formatNumberShort(number) + units;
    }

    public static String prependFormatTag(String str, char format) {
        return "\u00a7" + format + str;
    }

    public static String appendResetTag(String str) {
        return str + "\u00a7r";
    }

    public static String wrapFormatTags(String str, char format) {
        return StringUtils.appendResetTag(StringUtils.prependFormatTag(str, format));
    }

    public static String wrapFormatTags(String str, FormatCodes code) {
        return StringUtils.wrapFormatTags(str, code.character);
    }

    public static String wrapMultipleFormatTags(String str, Object ... tags) {
        for (Object tag : tags) {
            if (tag instanceof Character) {
                str = StringUtils.prependFormatTag(str, ((Character)tag).charValue());
                continue;
            }
            if (!(tag instanceof FormatCodes)) continue;
            str = StringUtils.prependFormatTag(str, ((FormatCodes)((Object)tag)).character);
        }
        return StringUtils.appendResetTag(str);
    }

    public static List<ITextComponent> wrapStringToLength(String str, int length) {
        if (str == null) {
            str = "";
        }
        String[] stringArray = StringUtils.wordUtilsWrap(str, length);
        ArrayList<ITextComponent> retList = new ArrayList<ITextComponent>();
        for (String s : stringArray) {
            retList.add((ITextComponent)new StringTextComponent(s));
        }
        return retList;
    }

    static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static String[] wordUtilsWrap(String str, int wrapLength) {
        if (str == null) {
            return null;
        }
        String newLineStr = System.lineSeparator();
        String wrapOn = " ";
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        if (StringUtils.isBlank(wrapOn)) {
            wrapOn = " ";
        }
        Pattern patternToWrapOn = Pattern.compile(wrapOn);
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (offset < inputLineLength) {
            int spaceToWrapAt = -1;
            Matcher matcher = patternToWrapOn.matcher(str.substring(offset, Math.min((int)Math.min(Integer.MAX_VALUE, (long)(offset + wrapLength) + 1L), inputLineLength)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    offset += matcher.end();
                    continue;
                }
                spaceToWrapAt = matcher.start() + offset;
            }
            if (inputLineLength - offset <= wrapLength) break;
            while (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset;
            }
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            matcher = patternToWrapOn.matcher(str.substring(offset + wrapLength));
            if (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset + wrapLength;
            }
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str, offset, str.length());
            offset = inputLineLength;
        }
        wrappedLine.append(str, offset, str.length());
        return wrappedLine.toString().split(System.lineSeparator());
    }

    public static List<ITextComponent> wrapITextComponentToLength(ITextComponent component, int length) {
        if (component == null) {
            component = new StringTextComponent("");
        }
        return StringUtils.wrapStringToLength(component.func_150261_e(), length);
    }

    public static List<String> wrapStringToVisualLength(String str, double length) {
        ArrayList<String> strlist = new ArrayList<String>();
        String[] words = str.split(" ");
        if (words.length == 0) {
            return null;
        }
        String currLine = words[0];
        for (int i = 1; i < words.length; ++i) {
            String approxLine = currLine + " " + words[i];
            if ((double)Minecraft.func_71410_x().field_71466_p.func_78256_a(approxLine) > length) {
                strlist.add(currLine);
                currLine = " " + words[i];
                continue;
            }
            currLine = approxLine;
        }
        strlist.add(currLine);
        return strlist;
    }

    public static void drawLeftAlignedText(MatrixStack matrixStack, ITextComponent text, double x, double y, Colour colour) {
        StringUtils.drawText(matrixStack, text, x, y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawLeftAlignedText(MatrixStack matrixStack, String s, double x, double y, Colour colour) {
        StringUtils.drawText(matrixStack, s, x, y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawRightAlignedText(MatrixStack matrixStack, ITextComponent text, double x, double y, Colour colour) {
        StringUtils.drawText(matrixStack, text, x - StringUtils.getStringWidth((ITextProperties)text), y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawRightAlignedText(MatrixStack matrixStack, String s, double x, double y, Colour colour) {
        StringUtils.drawText(matrixStack, s, x - StringUtils.getStringWidth(s), y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawCenteredText(MatrixStack matrixStack, ITextComponent component, double x, double y, Colour colour) {
        StringUtils.drawCenteredText(matrixStack, component, (float)x, (float)y, colour);
    }

    public static void drawCenteredText(MatrixStack matrixStack, ITextComponent component, float x, float y, Colour colour) {
        StringUtils.drawText(matrixStack, component, (double)(x - (float)(StringUtils.getFontRenderer().func_238414_a_((ITextProperties)component) / 2)), (double)y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawCenteredText(MatrixStack matrixStack, String s, double x, double y, Colour colour) {
        StringUtils.drawText(matrixStack, s, x - (double)(StringUtils.getFontRenderer().func_78256_a(s) / 2), y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawCenteredText(MatrixStack matrixStack, String s, float x, float y, Colour colour) {
        StringUtils.drawText(matrixStack, s, (double)(x - (float)(StringUtils.getFontRenderer().func_78256_a(s) / 2)), (double)y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawText(MatrixStack matrixStack, ITextComponent component, double x, double y, Colour colour) {
        StringUtils.getFontRenderer().func_243248_b(matrixStack, component, (float)x, (float)y, colour.getInt());
    }

    public static void drawText(MatrixStack matrixStack, String s, double x, double y, Colour colour) {
        StringUtils.getFontRenderer().func_238421_b_(matrixStack, s, (float)x, (float)y, colour.getInt());
    }

    public static void drawShadowedStringCentered(MatrixStack matrixStack, ITextComponent text, double x, double y, Colour colour) {
        StringUtils.drawShadowedString(matrixStack, text, x - StringUtils.getStringWidth((ITextProperties)text) / 2.0, y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawShadowedStringCentered(MatrixStack matrixStack, ITextComponent text, double x, double y) {
        StringUtils.drawShadowedString(matrixStack, text, x - StringUtils.getStringWidth((ITextProperties)text) / 2.0, y - StringUtils.getStringHeight() * 0.5);
    }

    public static void drawShadowedStringCentered(MatrixStack matrixStack, String s, double x, double y, Colour colour) {
        StringUtils.drawShadowedString(matrixStack, s, x - StringUtils.getStringWidth(s) / 2.0, y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawShadowedStringCentered(MatrixStack matrixStack, String s, double x, double y) {
        StringUtils.drawShadowedString(matrixStack, s, x - StringUtils.getStringWidth(s) / 2.0, y - StringUtils.getStringHeight() * 0.5);
    }

    public static void drawRightAlignedShadowedString(MatrixStack matrixStack, ITextComponent text, double x, double y) {
        StringUtils.drawShadowedString(matrixStack, text, x - StringUtils.getStringWidth((ITextProperties)text), y - StringUtils.getStringHeight() * 0.5);
    }

    public static void drawRightAlignedShadowedString(MatrixStack matrixStack, String s, double x, double y, Colour colour) {
        StringUtils.drawShadowedString(matrixStack, s, x - StringUtils.getStringWidth(s), y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawRightAlignedShadowedString(MatrixStack matrixStack, String s, double x, double y) {
        StringUtils.drawShadowedString(matrixStack, s, x - StringUtils.getStringWidth(s), y - StringUtils.getStringHeight() * 0.5);
    }

    public static void drawLeftAlignedShadowedString(MatrixStack matrixStack, ITextComponent text, double x, double y) {
        StringUtils.drawShadowedString(matrixStack, text, x, y - StringUtils.getStringHeight() * 0.5);
    }

    public static void drawLeftAlignedShadowedString(MatrixStack matrixStack, ITextComponent text, double x, double y, Colour colour) {
        StringUtils.drawShadowedString(matrixStack, text, x, y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawLeftAlignedShadowedString(MatrixStack matrixStack, String s, double x, double y) {
        StringUtils.drawShadowedString(matrixStack, s, x, y - StringUtils.getStringHeight() * 0.5);
    }

    public static void drawLeftAlignedShadowedString(MatrixStack matrixStack, String s, double x, double y, Colour colour) {
        StringUtils.drawShadowedString(matrixStack, s, x, y - StringUtils.getStringHeight() * 0.5, colour);
    }

    public static void drawShadowedString(MatrixStack matrixStack, ITextComponent s, double x, double y) {
        StringUtils.drawShadowedString(matrixStack, s, x, y, Colour.WHITE);
    }

    public static void drawShadowedString(MatrixStack matrixStack, String s, double x, double y) {
        StringUtils.drawShadowedString(matrixStack, s, x, y, Colour.WHITE);
    }

    public static void drawShadowedString(MatrixStack matrixStack, ITextComponent s, double x, double y, Colour c) {
        StringUtils.getFontRenderer().func_243246_a(matrixStack, s, (float)((int)x), (float)((int)y), c.getInt());
    }

    public static void drawShadowedString(MatrixStack matrixStack, String s, double x, double y, Colour c) {
        StringUtils.getFontRenderer().func_238405_a_(matrixStack, s, (float)((int)x), (float)((int)y), c.getInt());
    }

    public static void drawShadowedStringsJustified(MatrixStack matrixStack, List<String> words, double x1, double x2, double y) {
        int totalwidth = 0;
        for (String word : words) {
            totalwidth = (int)((double)totalwidth + StringUtils.getStringWidth(word));
        }
        double spacing = (x2 - x1 - (double)totalwidth) / (double)(words.size() - 1);
        double currentwidth = 0.0;
        for (String word : words) {
            StringUtils.drawShadowedString(matrixStack, word, x1 + currentwidth, y);
            currentwidth += StringUtils.getStringWidth(word) + spacing;
        }
    }

    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static double getStringWidth(String s) {
        return StringUtils.getFontRenderer().func_78256_a(s);
    }

    public static double getStringHeight() {
        StringUtils.getFontRenderer().getClass();
        return 9.0;
    }

    public static double getStringWidth(ITextProperties s) {
        return StringUtils.getFontRenderer().func_238414_a_(s);
    }

    public static double getStringWidth(IReorderingProcessor s) {
        return StringUtils.getFontRenderer().func_243245_a(s);
    }

    public static enum FormatCodes {
        Black('0'),
        DarkBlue('1'),
        DarkGreen('2'),
        DarkAqua('3'),
        DarkRed('4'),
        Purple('5'),
        Gold('6'),
        Grey('7'),
        DarkGrey('8'),
        Indigo('9'),
        BrightGreen('a'),
        Aqua('b'),
        Red('c'),
        Pink('d'),
        Yellow('e'),
        White('f'),
        RandomChar('k'),
        Bold('l'),
        Strike('m'),
        Underlined('n'),
        Italic('o'),
        Reset('r');

        public final char character;

        private FormatCodes(char character) {
            this.character = character;
        }
    }
}

