/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.network.packets;

import java.util.function.Supplier;
import lehjr.numina.common.capabilities.player.CapabilityPlayerKeyStates;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerUpdatePacket {
    boolean forwardKeyState;
    byte strafeKeyState;
    boolean downKeyState;
    boolean jumpKeyState;

    public PlayerUpdatePacket(boolean forwardKeyState, byte strafeKeyState, boolean downKeyState, boolean jumpKeyState) {
        this.forwardKeyState = forwardKeyState;
        this.strafeKeyState = strafeKeyState;
        this.downKeyState = downKeyState;
        this.jumpKeyState = jumpKeyState;
    }

    public static void encode(PlayerUpdatePacket msg, PacketBuffer packetBuffer) {
        packetBuffer.writeBoolean(msg.forwardKeyState);
        packetBuffer.writeByte((int)msg.strafeKeyState);
        packetBuffer.writeBoolean(msg.downKeyState);
        packetBuffer.writeBoolean(msg.jumpKeyState);
    }

    public static PlayerUpdatePacket decode(PacketBuffer packetBuffer) {
        return new PlayerUpdatePacket(packetBuffer.readBoolean(), packetBuffer.readByte(), packetBuffer.readBoolean(), packetBuffer.readBoolean());
    }

    public static void handle(PlayerUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> player.getCapability(CapabilityPlayerKeyStates.PLAYER_KEYSTATES).ifPresent(playerCap -> {
            playerCap.setForwardKeyState(message.forwardKeyState);
            playerCap.setStrafeKeyState(message.strafeKeyState);
            playerCap.setDownKeyState(message.downKeyState);
            playerCap.setJumpKeyState(message.jumpKeyState);
        }));
        ctx.get().setPacketHandled(true);
    }
}

