/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.render.modelspec;

import java.util.Objects;
import lehjr.numina.client.model.obj.OBJBakedCompositeModel;
import lehjr.numina.common.capabilities.render.modelspec.EnumSpecType;
import lehjr.numina.common.capabilities.render.modelspec.ModelRegistry;
import lehjr.numina.common.capabilities.render.modelspec.SpecBase;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.vector.TransformationMatrix;

public class ModelSpec
extends SpecBase {
    private final OBJBakedCompositeModel model;
    private final IModelTransform modelTransforms;

    public ModelSpec(OBJBakedCompositeModel model, IModelTransform transforms, String name, boolean isDefault, EnumSpecType specType) {
        super(name, isDefault, specType);
        this.modelTransforms = transforms;
        this.model = model;
    }

    public TransformationMatrix getTransform(ItemCameraTransforms.TransformType transformType) {
        TransformationMatrix transformation = this.modelTransforms.getPartTransformation((Object)transformType);
        return transformation;
    }

    @Override
    public String getDisaplayName() {
        return I18n.func_135052_a((String)("model." + this.getOwnName() + ".modelName"), (Object[])new Object[0]);
    }

    @Override
    public String getOwnName() {
        String name = (String)ModelRegistry.getInstance().getName(this);
        return name != null ? name : "";
    }

    public OBJBakedCompositeModel getModel() {
        return this.model;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelSpec modelSpec = (ModelSpec)o;
        return Objects.equals(this.model, modelSpec.model) && Objects.equals(this.modelTransforms, modelSpec.modelTransforms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.model, this.modelTransforms);
    }
}

