/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.meter;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import lehjr.numina.client.render.IconUtils;
import lehjr.numina.common.constants.NuminaConstants;
import lehjr.numina.common.math.Colour;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class HeatMeter {
    final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("minecraft:block/lava_still");
    final int xsize = 32;
    final int ysize = 8;
    float meterStart;
    float meterLevel;

    public float getAlpha() {
        return 0.7f;
    }

    public Colour getColour() {
        return Colour.WHITE;
    }

    public TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(this.TEXTURE_LOCATION);
    }

    public void draw(MatrixStack poseStack, float xpos, float ypos, float value) {
        RenderSystem.enableBlend();
        this.drawFluid(poseStack, xpos, ypos, value, this.getTexture());
        this.drawGlass(poseStack, xpos, ypos);
        RenderSystem.disableBlend();
    }

    public void drawFluid(MatrixStack poseStack, float xpos, float ypos, float value, TextureAtlasSprite icon) {
        poseStack.func_227860_a_();
        poseStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        this.meterStart = xpos;
        this.meterLevel = xpos + 32.0f * value;
        while (this.meterStart + 8.0f < this.meterLevel) {
            IconUtils.drawIconAt(poseStack, this.meterStart * 2.0f, ypos * 2.0f, icon, this.getColour().withAlpha(this.getAlpha()));
            this.meterStart += 8.0f;
        }
        IconUtils.drawIconPartial(poseStack, this.meterStart * 2.0f, ypos * 2.0f, icon, this.getColour().withAlpha(this.getAlpha()), 0.0f, 0.0f, (this.meterLevel - this.meterStart) * 2.0f, 16.0f);
        poseStack.func_227865_b_();
    }

    public void drawGlass(MatrixStack poseStack, float xpos, float ypos) {
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float blitOffset = 0.0f;
        float left = xpos;
        float right = left + 32.0f;
        float top = ypos;
        float bottom = top + 8.0f;
        Matrix4f matrix4f = poseStack.func_227866_c_().func_227870_a_();
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        textureManager.func_110577_a(NuminaConstants.GLASS_TEXTURE);
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tesselator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f, left, bottom, blitOffset).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, right, bottom, blitOffset).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, right, top, blitOffset).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, left, top, blitOffset).func_225583_a_(minU, maxV).func_181675_d();
        tesselator.func_78381_a();
    }
}

