/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.frame;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import lehjr.numina.client.gui.clickable.IClickable;
import lehjr.numina.client.gui.frame.GUISpacer;
import lehjr.numina.client.gui.frame.IGuiFrame;
import lehjr.numina.client.gui.frame.IScrollable;
import lehjr.numina.client.gui.gemoetry.IDrawable;
import lehjr.numina.client.gui.gemoetry.IDrawableRect;
import lehjr.numina.client.gui.gemoetry.IRect;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import net.minecraft.util.text.ITextComponent;

public class ScrollableMultiRectFrame<T extends Map<Integer, IRect>>
extends GUISpacer
implements IScrollable {
    protected int buttonSize = 5;
    protected int totalSize;
    protected int currentScrollPixels;
    protected double scrollAmount = 8.0;
    protected double margin;
    protected double maxHeight = -1.0;
    protected double maxWidth = -1.0;
    float zLevel;
    boolean isEnabled = true;
    boolean isVisible = true;
    @Nullable
    IDrawableRect background = null;
    Map<Integer, IRect> rects = new HashMap<Integer, IRect>();
    boolean startTop;

    public ScrollableMultiRectFrame(boolean startTop, double minWidth, double minHeight) {
        super(minWidth, minHeight);
        this.startTop = startTop;
    }

    public ScrollableMultiRectFrame(boolean startTop, double minWidth, double minHeight, double maxWidth, double maxHeight) {
        super(minWidth, minHeight);
        this.startTop = startTop;
        this.maxHeight = maxHeight;
        this.maxWidth = maxWidth;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public ScrollableMultiRectFrame addRect(IRect rect) {
        if (this.rects.size() > 0) {
            if (this.startTop) {
                rect.setMeBelow(this.rects.get(this.rects.size() - 1));
            } else {
                rect.setMeAbove(this.rects.get(this.rects.size() - 1));
            }
        }
        this.rects.put(this.rects.size(), rect);
        return this;
    }

    public ScrollableMultiRectFrame setMaxHeight(double maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public ScrollableMultiRectFrame setMaxWidth(double maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public ScrollableMultiRectFrame setMinHeight(double minHeight) {
        super.setHeight(minHeight);
        return this;
    }

    public ScrollableMultiRectFrame setMinWidth(double minWidth) {
        super.setWidth(minWidth);
        return this;
    }

    public Optional<IRect> getLast() {
        return Optional.ofNullable(this.rects.size() > 0 ? this.rects.get(this.rects.size() - 1) : null);
    }

    public void setRects(Map<Integer, IRect> rects) {
        this.rects = rects;
    }

    public Map<Integer, IRect> getRects() {
        return this.rects;
    }

    public void doneAdding() {
        double finalVal = 0.0;
        double highestVal = 0.0;
        for (IRect rect : this.rects.values()) {
            finalVal += rect.finalHeight();
            if (!(rect.finalWidth() > highestVal)) continue;
            highestVal = rect.finalWidth();
        }
        highestVal += this.margin * 2.0;
        if (this.maxWidth > 0.0) {
            super.setWidth(Math.min(Math.max(highestVal, super.finalWidth()), this.maxWidth));
        } else {
            super.setWidth(Math.max(highestVal, super.finalWidth()));
        }
        if (this.maxHeight > 0.0) {
            super.setHeight(Math.min(Math.max(finalVal, super.finalHeight()), this.maxHeight));
            this.totalSize = (int)(finalVal + 10.0);
        } else {
            super.setHeight(Math.max(finalVal, super.finalHeight()));
        }
    }

    public ScrollableMultiRectFrame setBackground(IDrawableRect background) {
        this.background = background;
        return this;
    }

    Optional<IDrawableRect> getBackground() {
        return Optional.ofNullable(this.background);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!IScrollable.super.mouseClicked(mouseX, mouseY, button)) return false;
        double scrollY = mouseY + (double)this.currentScrollPixels;
        if (this.rects.values().stream().filter(IGuiFrame.class::isInstance).map(IGuiFrame.class::cast).anyMatch(rect -> rect.mouseClicked(mouseX, scrollY, button))) return true;
        if (!this.rects.values().stream().filter(IClickable.class::isInstance).map(IClickable.class::cast).anyMatch(rect -> rect.mouseClicked(mouseX, scrollY, button))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        double scrollY = mouseY + (double)this.currentScrollPixels;
        if (this.rects.values().stream().filter(IGuiFrame.class::isInstance).map(IGuiFrame.class::cast).anyMatch(rect -> rect.mouseReleased(mouseX, scrollY, button))) return true;
        if (!this.rects.values().stream().filter(IClickable.class::isInstance).map(IClickable.class::cast).anyMatch(rect -> rect.mouseReleased(mouseX, scrollY, button))) return false;
        return true;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        if (IScrollable.super.mouseScrolled(mouseX, mouseY, dWheel)) {
            return this.rects.values().stream().filter(IGuiFrame.class::isInstance).map(IGuiFrame.class::cast).anyMatch(rect -> rect.mouseScrolled(mouseX, mouseY, dWheel));
        }
        return false;
    }

    public void renderRects(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        if (this.isVisible()) {
            for (IRect rect : this.rects.values()) {
                if (!(rect instanceof IDrawable)) continue;
                ((IDrawable)((Object)rect)).func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
            }
        }
    }

    @Override
    public void preRender(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        IScrollable.super.preRender(matrixStack, mouseX, mouseY, frameTime);
    }

    public void renderBackground(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        this.getBackground().ifPresent(background -> background.func_230430_a_(matrixStack, mouseX, mouseY, frameTime));
    }

    @Override
    public void postRender(int mouseX, int mouseY, float frameTime) {
        IScrollable.super.postRender(mouseX, mouseY, frameTime);
    }

    public void superRender(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
        if (this.isVisible()) {
            this.renderBackground(matrixStack, mouseX, mouseY, frameTime);
            this.preRender(matrixStack, mouseX, mouseY, frameTime);
            this.renderRects(matrixStack, mouseX, mouseY, frameTime);
            this.postRender(mouseX, mouseY, frameTime);
        }
    }

    @Override
    public List<ITextComponent> getToolTip(int x, int y) {
        List<ITextComponent> toolTip = null;
        for (IRect rect : this.rects.values()) {
            if (rect instanceof IDrawableRect) {
                toolTip = ((IDrawableRect)rect).getToolTip(x, y);
            }
            if (toolTip == null) continue;
            return toolTip;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        for (IRect rect : this.rects.values()) {
            if (rect instanceof IClickable) {
                ((IClickable)rect).setEnabled(enabled);
            }
            if (!(rect instanceof IGuiFrame)) continue;
            ((IGuiFrame)rect).setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
        for (IRect rect : this.rects.values()) {
            if (rect instanceof IClickable) {
                ((IClickable)rect).setVisible(visible);
            }
            if (!(rect instanceof IGuiFrame)) continue;
            ((IGuiFrame)rect).setVisible(visible);
        }
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public float getZLevel() {
        return this.zLevel;
    }

    @Override
    public IDrawable setZLevel(float zLevel) {
        this.zLevel = zLevel;
        for (IRect rect : this.rects.values()) {
            if (!(rect instanceof IDrawable)) continue;
            ((IDrawable)((Object)rect)).setZLevel(zLevel);
        }
        return this;
    }

    @Override
    public void initGrowth() {
        super.initGrowth();
        for (IRect rect : this.rects.values()) {
            rect.initGrowth();
        }
        this.refreshRects();
    }

    public void refreshRects() {
        if (this.rects.size() > 0) {
            if (this.startTop) {
                this.rects.get(0).setTop(this.finalTop());
            } else {
                this.rects.get(this.rects.size() - 1).setBottom(this.finalBottom());
            }
            for (int i = 0; i < this.rects.size(); ++i) {
                this.rects.get(i).setTop(this.rects.get(i).finalTop());
                this.rects.get(i).setLeft(this.centerx() - this.rects.get(i).finalWidth() * 0.5);
            }
        }
        this.getBackground().ifPresent(rect -> {
            rect.setPosition(this.getPosition());
            rect.setWidth(this.finalWidth());
            rect.setHeight(this.finalHeight());
        });
    }

    @Override
    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    @Override
    public int getButtonSize() {
        return this.buttonSize;
    }

    @Override
    public void setButtonSize(int buttonSize) {
        this.buttonSize = buttonSize;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public int getCurrentScrollPixels() {
        return this.currentScrollPixels;
    }

    @Override
    public void setCurrentScrollPixels(int scrollPixels) {
        this.currentScrollPixels = scrollPixels;
    }

    @Override
    public double getScrollAmount() {
        return this.scrollAmount;
    }

    @Override
    public void setScrollAmount(double scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    @Override
    public void update(double mouseX, double mouseY) {
        for (IRect rect : this.rects.values()) {
            if (!(rect instanceof IGuiFrame)) continue;
            ((IGuiFrame)rect).update(mouseX, mouseY);
        }
    }

    @Override
    public IRect setWH(MusePoint2D wh) {
        return this;
    }

    @Override
    public void doThisOnChange() {
        this.refreshRects();
        super.doThisOnChange();
    }
}

