/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lehjr.numina.client.gui.clickable.Clickable;
import lehjr.numina.client.gui.gemoetry.DrawableTile;
import lehjr.numina.client.gui.gemoetry.IDrawable;
import lehjr.numina.client.gui.gemoetry.IRect;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.common.math.Colour;
import lehjr.numina.common.math.MathUtils;
import lehjr.numina.common.string.StringUtils;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;

public class RangedSlider
extends Clickable {
    String id = "";
    protected boolean isHorizontal = true;
    protected double tickVal = 0.0;
    protected boolean showTickLines = false;
    public double sliderValue = 1.0;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    float zLevel = 0.0f;
    protected final double thickness = 8.0;
    protected double size = 16.0;
    private ITextComponent label;
    DrawableTile knobRect;
    DrawableTile trackRect;
    public boolean dragging = false;
    @Nullable
    public ISlider parent = null;

    public RangedSlider(MusePoint2D position, boolean isHorizontal, double size, ITextComponent label, String id, double minVal, double maxVal, double currentVal) {
        this(position, isHorizontal, size, label, id, minVal, maxVal, currentVal, null);
    }

    public RangedSlider(MusePoint2D position, boolean isHorizontal, double size, ITextComponent label, String id, double minVal, double maxVal, double currentVal, @Nullable ISlider iSlider) {
        this.isHorizontal = isHorizontal;
        this.size = size;
        this.label = label;
        this.id = id;
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.parent = iSlider;
        this.setValue(currentVal);
        this.setPosition(position);
        this.calculateTickCoordinates();
        this.setDoThisOnChange(doThis -> this.createNewRects());
    }

    public String id() {
        return this.id;
    }

    public void setTickVal(double tickVal) {
        this.tickVal = Math.abs(tickVal);
        this.calculateTickCoordinates();
    }

    public void setShowTickLines(boolean showTickLines) {
        this.showTickLines = showTickLines;
    }

    List<Double> calculateTickCoordinates() {
        ArrayList<Double> vals = new ArrayList<Double>();
        if (this.tickVal != 0.0) {
            for (double i = this.minValue + this.tickVal; i < this.maxValue; i += this.tickVal) {
                vals.add((this.isHorizontal ? this.trackRect.finalLeft() : this.trackRect.finalTop()) + this.size * MathUtils.clampDouble((i - this.minValue) / (this.maxValue - this.minValue), 0.0, 1.0));
            }
        }
        return vals;
    }

    void createNewRects() {
        if (this.isHorizontal) {
            this.knobRect = new DrawableTile(this.getPosition().getX() - 4.0, this.getPosition().getY() - 1.0 - 4.0, this.getPosition().getX() + 4.0, this.getPosition().getY() + 1.0 + 4.0);
            this.trackRect = new DrawableTile(this.getPosition().getX() - this.size * 0.5, this.getPosition().getY() - 4.0, this.getPosition().getX() + this.size * 0.5, this.getPosition().getY() + 4.0);
        } else {
            this.knobRect = new DrawableTile(this.getPosition().getX() - 1.0 - 4.0, this.getPosition().getY() - 4.0, this.getPosition().getX() + 1.0 + 4.0, this.getPosition().getY() + 4.0);
            this.trackRect = new DrawableTile(this.getPosition().getX() - 4.0, this.getPosition().getY() - this.size * 0.5, this.getPosition().getX() + 4.0, this.getPosition().getY() + this.size * 0.5);
        }
        this.knobRect.setBackgroundColour(Colour.LIGHT_GREY);
        this.knobRect.setBottomBorderColour(Colour.BLACK);
        this.knobRect.setTopBorderColour(Colour.WHITE);
        this.trackRect.setBackgroundColour(Colour.DARK_GREY);
        this.trackRect.setBottomBorderColour(Colour.WHITE);
        this.trackRect.setTopBorderColour(Colour.BLACK);
        super.setWH(new MusePoint2D(this.trackRect.finalWidth(), this.trackRect.finalHeight()));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        if (this.isVisible()) {
            if (this.label != null) {
                StringUtils.drawShadowedStringCentered(matrixStack, this.label.getString(), this.getPosition().getX(), this.getPosition().getY());
            }
            this.trackRect.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
            if (this.isHorizontal) {
                this.knobRect.setPosition(new MusePoint2D(this.getPosition().getX() + this.size * (this.sliderValue - 0.5), this.trackRect.centery()));
            } else {
                this.knobRect.setPosition(new MusePoint2D(this.trackRect.centerx(), this.getPosition().getY() + this.size * (this.sliderValue - 0.5)));
            }
            if (this.showTickLines && this.tickVal != 0.0) {
                if (this.isHorizontal) {
                    for (double val : this.calculateTickCoordinates()) {
                        this.drawSingleLine(matrixStack, val, this.trackRect.finalTop(), val, this.trackRect.finalBottom(), Colour.WHITE);
                    }
                } else {
                    for (double val : this.calculateTickCoordinates()) {
                        this.drawSingleLine(matrixStack, this.trackRect.finalLeft(), val, this.trackRect.finalRight(), val, Colour.WHITE);
                    }
                }
            }
            this.knobRect.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
        }
    }

    @Override
    public float getZLevel() {
        return this.zLevel;
    }

    @Override
    public IDrawable setZLevel(float zLevel) {
        this.knobRect.setZLevel(zLevel);
        this.trackRect.setZLevel(zLevel);
        this.zLevel = zLevel;
        return this;
    }

    public void update(double mouseX, double mouseY) {
        double siderStart = this.sliderValue;
        this.sliderValue = this.isEnabled() && this.isVisible() && this.dragging ? (this.isHorizontal ? MathUtils.clampDouble((mouseX - this.getPosition().getX()) / (this.size - this.knobRect.finalWidth() * 0.5) + 0.5, 0.0, 1.0) : MathUtils.clampDouble((mouseY - this.getPosition().getY()) / (this.size - this.knobRect.finalHeight() * 0.5) + 0.5, 0.0, 1.0)) : MathUtils.clampDouble(this.sliderValue, 0.0, 1.0);
        this.setValue(this.getValue());
        if (siderStart != this.sliderValue && this.parent != null) {
            this.parent.onChangeSliderValue(this);
        }
    }

    public void setLabel(ITextComponent label) {
        this.label = label;
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public double getValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double value) {
        if (value != 0.0 && this.tickVal != 0.0) {
            value -= value % this.tickVal;
        }
        this.sliderValue = MathUtils.clampDouble((value - this.minValue) / (this.maxValue - this.minValue), 0.0, 1.0);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.dragging) {
            this.update(mouseX, mouseY);
            this.dragging = false;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.isVisible() && this.hitBox(mouseX, mouseY)) {
            this.update(mouseX, mouseY);
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean hitBox(double x, double y) {
        return x > this.trackRect.left() - 2.0 && x < this.trackRect.right() + 2.0 && y > this.trackRect.top() - 2.0 && y < this.trackRect.bottom() + 2.0;
    }

    @Override
    public void setPosition(MusePoint2D position) {
        super.setPosition(position);
        this.createNewRects();
    }

    @Override
    public IRect setWH(MusePoint2D wh) {
        this.createNewRects();
        return this;
    }

    @Override
    public IRect setWidth(double value) {
        this.createNewRects();
        return this;
    }

    @Override
    public IRect setHeight(double value) {
        this.createNewRects();
        return this;
    }

    void drawSingleLine(MatrixStack matrixStack, double xStart, double yStart, double xEnd, double yEnd, Colour colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        this.preDraw(1, DefaultVertexFormats.field_181706_f);
        RenderSystem.lineWidth((float)1.0f);
        builder.func_227888_a_(matrix4f, (float)xStart, (float)yStart, this.getZLevel()).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)xEnd, (float)yEnd, this.getZLevel()).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_181675_d();
        this.drawTesselator();
        this.postDraw();
    }

    public static interface ISlider {
        public void onChangeSliderValue(RangedSlider var1);
    }
}

