/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.control;

import lehjr.numina.common.capabilities.player.CapabilityPlayerKeyStates;
import lehjr.numina.common.capabilities.player.IPlayerKeyStates;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerMovementInputWrapper {
    public static PlayerMovementInput get(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            if (player instanceof RemoteClientPlayerEntity) {
                return PlayerMovementInputWrapper.fromServer(player);
            }
            return PlayerMovementInputWrapper.fromClient(player);
        }
        return PlayerMovementInputWrapper.fromServer(player);
    }

    static LazyOptional<IPlayerKeyStates> getCapability(PlayerEntity player) {
        return player.getCapability(CapabilityPlayerKeyStates.PLAYER_KEYSTATES, null);
    }

    static PlayerMovementInput fromServer(PlayerEntity player) {
        boolean forwardKey = false;
        byte strafeKey = 0;
        boolean jumpKey = false;
        boolean downKey = false;
        LazyOptional<IPlayerKeyStates> playerCap = PlayerMovementInputWrapper.getCapability(player);
        if (playerCap.isPresent()) {
            forwardKey = playerCap.map(m -> m.getForwardKeyState()).orElse(false);
            strafeKey = playerCap.map(m -> m.getStrafeKeyState()).orElse((byte)0);
            jumpKey = playerCap.map(m -> m.getJumpKeyState()).orElse(false);
            downKey = playerCap.map(m -> m.getDownKeyState()).orElse(false);
        }
        return new PlayerMovementInput(forwardKey, strafeKey, jumpKey, downKey);
    }

    static PlayerMovementInput fromClient(PlayerEntity player) {
        boolean forwardKey = false;
        byte strafeKey = 0;
        boolean jumpKey = false;
        boolean downKey = false;
        LazyOptional<IPlayerKeyStates> playerCap = PlayerMovementInputWrapper.getCapability(player);
        if (playerCap.isPresent()) {
            forwardKey = playerCap.map(m -> m.getForwardKeyState()).orElse(false);
            strafeKey = playerCap.map(m -> m.getStrafeKeyState()).orElse((byte)0);
            jumpKey = playerCap.map(m -> m.getJumpKeyState()).orElse(false);
            downKey = playerCap.map(m -> m.getDownKeyState()).orElse(false);
        }
        return new PlayerMovementInput(forwardKey, strafeKey, jumpKey, downKey);
    }

    public static class PlayerMovementInput {
        public boolean forwardKey;
        public byte strafeKey;
        public boolean jumpKey;
        public boolean downKey;

        public PlayerMovementInput(boolean forwardKey, byte strafeKey, boolean jumpKey, boolean downKey) {
            this.forwardKey = forwardKey;
            this.strafeKey = strafeKey;
            this.jumpKey = jumpKey;
            this.downKey = downKey;
        }
    }
}

