/*
 * Decompiled with CFR 0.152.
 */
package com.rydelfox.morestoragedrawers.network;

import com.rydelfox.morestoragedrawers.block.tile.TileEntityDrawersMore;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class ItemUpdateMessage {
    private BlockPos pos;
    private int slot;
    private ItemStack item;
    private boolean failed;

    public ItemUpdateMessage(BlockPos pos, int slot, ItemStack item) {
        this.pos = pos;
        this.slot = slot;
        this.item = item;
        this.failed = false;
    }

    private ItemUpdateMessage(boolean failed) {
        this.failed = failed;
    }

    public static ItemUpdateMessage decode(PacketBuffer buf) {
        return new ItemUpdateMessage(buf.func_179259_c(), buf.readByte(), buf.func_150791_c());
    }

    public static void encode(ItemUpdateMessage object, PacketBuffer buf) {
        buf.func_179255_a(object.pos);
        buf.writeByte(object.slot);
        buf.writeItemStack(object.item, false);
    }

    public static void handle(ItemUpdateMessage msg, Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ItemUpdateMessage.lambda$null$0(msg, (Supplier)ctx));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(ItemUpdateMessage msg, NetworkEvent.Context ctx) {
        BlockPos pos;
        TileEntity tileEntity;
        ClientWorld world;
        if (!msg.failed && (world = Minecraft.func_71410_x().field_71441_e) != null && (tileEntity = world.func_175625_s(pos = msg.pos)) instanceof TileEntityDrawersMore) {
            ((TileEntityDrawersMore)tileEntity).clientUpdateItem(msg.slot, msg.item);
        }
    }

    private static /* synthetic */ void lambda$null$0(ItemUpdateMessage msg, Supplier ctx) {
        ItemUpdateMessage.handleClient(msg, (NetworkEvent.Context)ctx.get());
    }
}

