/*
 * Decompiled with CFR 0.152.
 */
package com.rydelfox.morestoragedrawers.datagen;

import com.rydelfox.morestoragedrawers.MoreStorageDrawers;
import com.rydelfox.morestoragedrawers.block.DrawerMaterial;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class DrawerRecipeProvider
extends RecipeProvider {
    public DrawerRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        MoreStorageDrawers.logInfo("Generating Recipes");
        for (DrawerMaterial material : DrawerMaterial.values()) {
            if (material.getMod() == null || !material.getMod().isLoaded()) continue;
            this.build_full_1(material, consumer);
            this.build_full_2(material, consumer);
            this.build_full_4(material, consumer);
            this.build_trim(material, consumer);
            this.build_half_1(material, consumer);
            this.build_half_2(material, consumer);
            this.build_half_4(material, consumer);
        }
    }

    private void build_full_1(DrawerMaterial material, Consumer<IFinishedRecipe> consumer) {
        if (material.getPlankResource() == null) {
            MoreStorageDrawers.logInfo("Could not generate recipe for " + material.getEnglishName() + "! Could not load plank!");
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(material.getPlankResource());
        ShapedRecipeBuilder.func_200470_a((IItemProvider)material.getDrawer(1, false)).func_200472_a("///").func_200472_a(" x ").func_200472_a("///").func_200462_a(Character.valueOf('/'), (IItemProvider)plank).func_200469_a(Character.valueOf('x'), (ITag)Tags.Items.CHESTS_WOODEN).func_200473_b("morestoragedrawers").func_200465_a("has_item", (ICriterionInstance)DrawerRecipeProvider.func_200409_a((ITag)Tags.Items.CHESTS_WOODEN)).func_200464_a(consumer);
    }

    private void build_full_2(DrawerMaterial material, Consumer<IFinishedRecipe> consumer) {
        if (material.getPlankResource() == null) {
            MoreStorageDrawers.logInfo("Could not generate recipe for " + material.getEnglishName() + "! Could not load plank!");
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(material.getPlankResource());
        ShapedRecipeBuilder.func_200468_a((IItemProvider)material.getDrawer(2, false), (int)2).func_200472_a("/x/").func_200472_a("///").func_200472_a("/x/").func_200462_a(Character.valueOf('/'), (IItemProvider)plank).func_200469_a(Character.valueOf('x'), (ITag)Tags.Items.CHESTS_WOODEN).func_200473_b("morestoragedrawers").func_200465_a("has_item", (ICriterionInstance)DrawerRecipeProvider.func_200409_a((ITag)Tags.Items.CHESTS_WOODEN)).func_200464_a(consumer);
    }

    private void build_full_4(DrawerMaterial material, Consumer<IFinishedRecipe> consumer) {
        if (material.getPlankResource() == null) {
            MoreStorageDrawers.logInfo("Could not generate recipe for " + material.getEnglishName() + "! Could not load plank!");
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(material.getPlankResource());
        ShapedRecipeBuilder.func_200468_a((IItemProvider)material.getDrawer(4, false), (int)4).func_200472_a("x/x").func_200472_a("///").func_200472_a("x/x").func_200462_a(Character.valueOf('/'), (IItemProvider)plank).func_200469_a(Character.valueOf('x'), (ITag)Tags.Items.CHESTS_WOODEN).func_200473_b("morestoragedrawers").func_200465_a("has_item", (ICriterionInstance)DrawerRecipeProvider.func_200409_a((ITag)Tags.Items.CHESTS_WOODEN)).func_200464_a(consumer);
    }

    private void build_half_1(DrawerMaterial material, Consumer<IFinishedRecipe> consumer) {
        if (material.getSlabResource() == null) {
            return;
        }
        Item slab = (Item)ForgeRegistries.ITEMS.getValue(material.getSlabResource());
        ShapedRecipeBuilder.func_200470_a((IItemProvider)material.getDrawer(1, true)).func_200472_a("///").func_200472_a(" x ").func_200472_a("///").func_200462_a(Character.valueOf('/'), (IItemProvider)slab).func_200469_a(Character.valueOf('x'), (ITag)Tags.Items.CHESTS_WOODEN).func_200473_b("morestoragedrawers").func_200465_a("has_item", (ICriterionInstance)DrawerRecipeProvider.func_200409_a((ITag)Tags.Items.CHESTS_WOODEN)).func_200464_a(consumer);
    }

    private void build_half_2(DrawerMaterial material, Consumer<IFinishedRecipe> consumer) {
        if (material.getSlabResource() == null) {
            return;
        }
        Item slab = (Item)ForgeRegistries.ITEMS.getValue(material.getSlabResource());
        ShapedRecipeBuilder.func_200468_a((IItemProvider)material.getDrawer(2, true), (int)2).func_200472_a("/x/").func_200472_a("///").func_200472_a("/x/").func_200462_a(Character.valueOf('/'), (IItemProvider)slab).func_200469_a(Character.valueOf('x'), (ITag)Tags.Items.CHESTS_WOODEN).func_200473_b("morestoragedrawers").func_200465_a("has_item", (ICriterionInstance)DrawerRecipeProvider.func_200409_a((ITag)Tags.Items.CHESTS_WOODEN)).func_200464_a(consumer);
    }

    private void build_half_4(DrawerMaterial material, Consumer<IFinishedRecipe> consumer) {
        if (material.getSlabResource() == null) {
            return;
        }
        Item slab = (Item)ForgeRegistries.ITEMS.getValue(material.getSlabResource());
        ShapedRecipeBuilder.func_200468_a((IItemProvider)material.getDrawer(4, true), (int)4).func_200472_a("x/x").func_200472_a("///").func_200472_a("x/x").func_200462_a(Character.valueOf('/'), (IItemProvider)slab).func_200469_a(Character.valueOf('x'), (ITag)Tags.Items.CHESTS_WOODEN).func_200473_b("morestoragedrawers").func_200465_a("has_item", (ICriterionInstance)DrawerRecipeProvider.func_200409_a((ITag)Tags.Items.CHESTS_WOODEN)).func_200464_a(consumer);
    }

    private void build_trim(DrawerMaterial material, Consumer<IFinishedRecipe> consumer) {
        if (material.getPlankResource() == null) {
            MoreStorageDrawers.logInfo("Could not generate recipe for " + material.getEnglishName() + "! Could not load plank!");
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(material.getPlankResource());
        ShapedRecipeBuilder.func_200468_a((IItemProvider)material.getTrim(), (int)4).func_200472_a("X/X").func_200472_a("/X/").func_200472_a("X/X").func_200462_a(Character.valueOf('X'), (IItemProvider)plank).func_200469_a(Character.valueOf('/'), (ITag)Tags.Items.RODS_WOODEN).func_200473_b("morestoragedrawers").func_200465_a("has_item", (ICriterionInstance)DrawerRecipeProvider.func_200403_a((IItemProvider)plank)).func_200464_a(consumer);
    }
}

