/*
 * Decompiled with CFR 0.152.
 */
package com.rydelfox.morestoragedrawers.datagen;

import com.rydelfox.morestoragedrawers.block.BlockMoreDrawers;
import com.rydelfox.morestoragedrawers.block.DrawerMaterial;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class DrawerBlockStateProvider
extends BlockStateProvider {
    public DrawerBlockStateProvider(DataGenerator dataGeneratorIn, ExistingFileHelper helper) {
        super(dataGeneratorIn, "morestoragedrawers", helper);
    }

    protected void registerStatesAndModels() {
        for (DrawerMaterial material : DrawerMaterial.values()) {
            if (material.getMod() == null || !material.getMod().isLoaded()) continue;
            BlockModelBuilder trimBlock = (BlockModelBuilder)this.models().cubeAll("block/" + material.getName() + "_trim", this.modLoc("blocks/" + material.prefix() + "_side"));
            this.simpleBlock((Block)material.getTrim(), (ModelFile)trimBlock);
            this.simpleBlockItem((Block)material.getTrim(), (ModelFile)trimBlock);
            this.horizontalDrawer(material.getDrawer(1, false), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_front_1"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_trim"), false);
            this.horizontalDrawer(material.getDrawer(2, false), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_front_2"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_trim"), false);
            this.horizontalDrawer(material.getDrawer(4, false), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_front_4"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_trim"), false);
            this.horizontalDrawer(material.getDrawer(1, true), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side_v"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_front_1"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side_h"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_trim"), true);
            this.horizontalDrawer(material.getDrawer(2, true), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side_v"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_front_2"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side_h"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_trim"), true);
            this.horizontalDrawer(material.getDrawer(4, true), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side_v"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_front_4"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side_h"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_side"), new ResourceLocation("morestoragedrawers", "blocks/" + material.prefix() + "_trim"), true);
        }
    }

    private void orientedBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir.func_176740_k() == Direction.Axis.Y ? dir.func_176743_c().func_179524_a() * -90 : 0).rotationY(dir.func_176740_k() != Direction.Axis.Y ? (dir.func_176736_b() + 2) % 4 * 90 : 0).build();
        });
    }

    protected void horizontalDrawer(BlockMoreDrawers block, ResourceLocation side, ResourceLocation front, ResourceLocation trim, boolean halfDepth) {
        this.horizontalDrawer(block, side, front, side, side, trim, halfDepth);
    }

    protected void horizontalDrawer(BlockMoreDrawers block, ResourceLocation side, ResourceLocation front, ResourceLocation top, ResourceLocation back, ResourceLocation trim, boolean halfDepth) {
        String builderPath = "block/builder/" + (halfDepth ? "half" : "full") + "drawermodelbuilder";
        ResourceLocation parent = !halfDepth ? this.modLoc("block/full_drawers") : this.modLoc("block/half_drawers");
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getRegistryName().func_110623_a(), parent)).texture("particle", front)).texture("east", side)).texture("west", side)).texture("north", front)).texture("up", top)).texture("down", top)).texture("south", back)).texture("trim", trim);
        this.buildDrawerState(block, (ModelFile)model);
    }

    protected void buildDrawerState(BlockMoreDrawers block, ModelFile model) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        builder.partialState().with((Property)BlockMoreDrawers.field_185512_D, (Comparable)Direction.NORTH).addModels(new ConfiguredModel[]{new ConfiguredModel(model)});
        builder.partialState().with((Property)BlockMoreDrawers.field_185512_D, (Comparable)Direction.EAST).addModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, 90, false)});
        builder.partialState().with((Property)BlockMoreDrawers.field_185512_D, (Comparable)Direction.SOUTH).addModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, 180, false)});
        builder.partialState().with((Property)BlockMoreDrawers.field_185512_D, (Comparable)Direction.WEST).addModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, 270, false)});
    }

    protected void buildDrawerItem(Item block) {
        this.models().withExistingParent(block.getRegistryName().func_110623_a(), this.modLoc("block/" + block.getRegistryName().func_110623_a()));
    }
}

