/*
 * Decompiled with CFR 0.152.
 */
package com.rydelfox.morestoragedrawers.core;

import com.rydelfox.morestoragedrawers.MoreStorageDrawers;
import com.rydelfox.morestoragedrawers.block.BlockDrawersExtended;
import com.rydelfox.morestoragedrawers.block.DrawerMaterial;
import com.rydelfox.morestoragedrawers.block.tile.Tiles;
import com.rydelfox.morestoragedrawers.datagen.DrawerBlockStateProvider;
import com.rydelfox.morestoragedrawers.datagen.DrawerItemModelProvider;
import com.rydelfox.morestoragedrawers.datagen.DrawerLootTableProvider;
import com.rydelfox.morestoragedrawers.datagen.DrawerRecipeProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="morestoragedrawers", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Registration {
    @SubscribeEvent
    public static void onBlockRegistry(RegistryEvent.Register<Block> event) {
        MoreStorageDrawers.logInfo("MoreStorageDrawers: Registering Blocks");
        for (DrawerMaterial material : DrawerMaterial.values()) {
            if (!material.getMod().isLoaded()) continue;
            material.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
        }
    }

    @SubscribeEvent
    public static void onItemRegistry(RegistryEvent.Register<Item> event) {
        MoreStorageDrawers.logInfo("MoreStorageDrawers: Registering Items");
        for (DrawerMaterial material : DrawerMaterial.values()) {
            if (!material.getMod().isLoaded()) continue;
            material.registerItems((IForgeRegistry<Item>)event.getRegistry());
        }
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        MoreStorageDrawers.logInfo("MoreStorageDrawers: Running Datagen");
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new DrawerRecipeProvider(generator));
            generator.func_200390_a((IDataProvider)new DrawerLootTableProvider(generator));
        }
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new DrawerBlockStateProvider(generator, helper));
            generator.func_200390_a((IDataProvider)new DrawerItemModelProvider(generator, helper));
        }
        try {
            generator.func_200392_c();
        }
        catch (IOException e) {
            MoreStorageDrawers.logInfo("DataGenerator#run threw an exception");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        MoreStorageDrawers.logInfo("MoreStorageDrawers: Registering Tile Entities");
        IForgeRegistry r = event.getRegistry();
        Tiles.registerTiles(r);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void bindRenderTypes() {
        ArrayList<Block> alldrawers = new ArrayList<Block>();
        for (DrawerMaterial material : DrawerMaterial.values()) {
            alldrawers.addAll(material.getBlocks(false));
        }
        for (Block block : alldrawers) {
            if (!(block instanceof BlockDrawersExtended)) continue;
            RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_());
        }
    }

    private static <T extends TileEntity> void registerTileEntity(RegistryEvent.Register<TileEntityType<?>> event, String name, Supplier<? extends T> factory, Block ... blocks) {
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(factory, (Block[])blocks).func_206865_a(null).setRegistryName(new ResourceLocation("morestoragedrawers", name)));
    }
}

