/*
 * Decompiled with CFR 0.152.
 */
package com.rydelfox.morestoragedrawers.client.model;

import com.google.common.collect.Lists;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.mojang.datafixers.util.Either;
import com.rydelfox.morestoragedrawers.MoreStorageDrawers;
import com.rydelfox.morestoragedrawers.block.BlockDrawersExtended;
import com.rydelfox.morestoragedrawers.block.BlockMoreDrawers;
import com.rydelfox.morestoragedrawers.block.DrawerMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class MoreDrawerModel {
    private static final Map<Direction, IBakedModel> lockOverlaysFull = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> lockOverlaysHalf = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> voidOverlaysFull = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> voidOverlaysHalf = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> shroudOverlaysFull = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> shroudOverlaysHalf = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> indicator1Full = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> indicator1Half = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> indicator2Full = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> indicator2Half = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> indicator4Full = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> indicator4Half = new HashMap<Direction, IBakedModel>();
    private static final Map<Direction, IBakedModel> indicatorComp = new HashMap<Direction, IBakedModel>();
    private static boolean geometryDataLoaded = false;

    @Mod.EventBusSubscriber(modid="morestoragedrawers", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Register {
        @SubscribeEvent
        public static void registerTextures(TextureStitchEvent.Pre event) {
            MoreStorageDrawers.logInfo("MoreStorageDrawers: Registering Textures");
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_lock.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_void.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_shroud.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/compdrawers_indicator.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_indicator_1.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_indicator_2.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_indicator_4.json"));
            Register.loadGeometryData();
        }

        private static void loadGeometryData() {
            if (geometryDataLoaded) {
                return;
            }
            geometryDataLoaded = true;
            ArrayList<BlockMoreDrawers> fullDrawers1 = new ArrayList<BlockMoreDrawers>();
            ArrayList<BlockMoreDrawers> fullDrawers2 = new ArrayList<BlockMoreDrawers>();
            ArrayList<BlockMoreDrawers> fullDrawers4 = new ArrayList<BlockMoreDrawers>();
            ArrayList halfDrawers1 = new ArrayList();
            ArrayList halfDrawers2 = new ArrayList();
            ArrayList halfDrawers4 = new ArrayList();
            for (DrawerMaterial material : DrawerMaterial.values()) {
                fullDrawers1.add(material.getDrawer(1, false));
                fullDrawers1.add(material.getDrawer(1, true));
                fullDrawers2.add(material.getDrawer(2, false));
                fullDrawers2.add(material.getDrawer(2, true));
                fullDrawers4.add(material.getDrawer(4, false));
                fullDrawers4.add(material.getDrawer(4, true));
            }
            MoreStorageDrawers.logInfo("MoreStorageDrawers: Populating Geometry");
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_icon_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_count_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_ind_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_indbase_area_1.json"), (BlockDrawersExtended[])fullDrawers1.stream().toArray(BlockMoreDrawers[]::new));
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_icon_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_count_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_ind_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_indbase_area_2.json"), (BlockDrawersExtended[])fullDrawers2.stream().toArray(BlockDrawersExtended[]::new));
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_icon_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_count_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_ind_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_indbase_area_4.json"), (BlockDrawersExtended[])fullDrawers4.stream().toArray(BlockDrawersExtended[]::new));
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_icon_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_count_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_ind_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_indbase_area_1.json"), (BlockDrawersExtended[])halfDrawers1.stream().toArray(BlockDrawersExtended[]::new));
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_icon_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_count_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_ind_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_indbase_area_2.json"), (BlockDrawersExtended[])halfDrawers2.stream().toArray(BlockDrawersExtended[]::new));
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_icon_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_count_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_ind_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_indbase_area_4.json"), (BlockDrawersExtended[])halfDrawers4.stream().toArray(BlockDrawersExtended[]::new));
        }

        private static void populateGeometryData(ResourceLocation locationIcon, ResourceLocation locationCount, ResourceLocation locationInd, ResourceLocation locationIndBase, BlockDrawersExtended ... blocks) {
            BlockModel slotInfo = Register.getBlockModel(locationIcon);
            BlockModel countInfo = Register.getBlockModel(locationCount);
            BlockModel indInfo = Register.getBlockModel(locationInd);
            BlockModel indBaseInfo = Register.getBlockModel(locationIndBase);
            for (BlockDrawersExtended block : blocks) {
                Vector3f to;
                Vector3f from;
                int i;
                if (block == null) continue;
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockPart)slotInfo.func_178298_a().get((int)i)).field_178241_a;
                    to = ((BlockPart)slotInfo.func_178298_a().get((int)i)).field_178239_b;
                    block.labelGeometry[i] = new AxisAlignedBB((double)from.func_195899_a(), (double)from.func_195900_b(), (double)from.func_195902_c(), (double)to.func_195899_a(), (double)to.func_195900_b(), (double)to.func_195902_c());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockPart)countInfo.func_178298_a().get((int)i)).field_178241_a;
                    to = ((BlockPart)countInfo.func_178298_a().get((int)i)).field_178239_b;
                    block.countGeometry[i] = new AxisAlignedBB((double)from.func_195899_a(), (double)from.func_195900_b(), (double)from.func_195902_c(), (double)to.func_195899_a(), (double)to.func_195900_b(), (double)to.func_195902_c());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockPart)indInfo.func_178298_a().get((int)i)).field_178241_a;
                    to = ((BlockPart)indInfo.func_178298_a().get((int)i)).field_178239_b;
                    block.indGeometry[i] = new AxisAlignedBB((double)from.func_195899_a(), (double)from.func_195900_b(), (double)from.func_195902_c(), (double)to.func_195899_a(), (double)to.func_195900_b(), (double)to.func_195902_c());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockPart)indBaseInfo.func_178298_a().get((int)i)).field_178241_a;
                    to = ((BlockPart)indBaseInfo.func_178298_a().get((int)i)).field_178239_b;
                    block.indBaseGeometry[i] = new AxisAlignedBB((double)from.func_195899_a(), (double)from.func_195900_b(), (double)from.func_195899_a(), (double)to.func_195902_c(), (double)to.func_195900_b(), (double)to.func_195902_c());
                }
            }
        }

        private static void loadUnbakedModel(TextureStitchEvent.Pre event, ResourceLocation resource) {
            BlockModel unbakedModel = Register.getBlockModel(resource);
            for (Either x : unbakedModel.field_178318_c.values()) {
                x.ifLeft(value -> {
                    if (value.func_229310_a_().equals((Object)event.getMap().func_229223_g_())) {
                        event.addSprite(value.func_229313_b_());
                    }
                });
            }
        }

        /*
         * Exception decompiling
         */
        private static BlockModel getBlockModel(ResourceLocation location) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @SubscribeEvent
        public static void registerModels(ModelBakeEvent event) {
            MoreStorageDrawers.logInfo("MoreStorageDrawers: Registering Models");
            for (int i = 0; i < 4; ++i) {
                Direction dir = Direction.func_176731_b((int)i);
                ModelRotation rot = ModelRotation.func_177524_a((int)0, (int)((int)dir.func_185119_l() + 180));
                Function texGet = ModelLoader.defaultTextureGetter();
                lockOverlaysFull.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/full_drawers_lock"), (IModelTransform)rot, texGet));
                lockOverlaysHalf.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/half_drawers_lock"), (IModelTransform)rot, texGet));
                voidOverlaysFull.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/full_drawers_void"), (IModelTransform)rot, texGet));
                voidOverlaysHalf.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/half_drawers_void"), (IModelTransform)rot, texGet));
                shroudOverlaysFull.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/full_drawers_shroud"), (IModelTransform)rot, texGet));
                shroudOverlaysHalf.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/half_drawers_shroud"), (IModelTransform)rot, texGet));
                indicator1Full.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/full_drawers_indicator_1"), (IModelTransform)rot, texGet));
                indicator1Half.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/half_drawers_indicator_1"), (IModelTransform)rot, texGet));
                indicator2Full.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/full_drawers_indicator_2"), (IModelTransform)rot, texGet));
                indicator2Half.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/half_drawers_indicator_2"), (IModelTransform)rot, texGet));
                indicator4Full.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/full_drawers_indicator_4"), (IModelTransform)rot, texGet));
                indicator4Half.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/half_drawers_indicator_4"), (IModelTransform)rot, texGet));
                indicatorComp.put(dir, event.getModelLoader().getBakedModel(new ResourceLocation("storagedrawers", "block/compdrawers_indicator"), (IModelTransform)rot, texGet));
            }
            for (DrawerMaterial material : DrawerMaterial.values()) {
                if (material.getMod() == null || !material.getMod().isLoaded()) continue;
                Register.replaceBlock(event, material.getDrawer(1, false));
                Register.replaceBlock(event, material.getDrawer(2, false));
                Register.replaceBlock(event, material.getDrawer(3, false));
                Register.replaceBlock(event, material.getDrawer(1, true));
                Register.replaceBlock(event, material.getDrawer(2, true));
                Register.replaceBlock(event, material.getDrawer(3, true));
            }
        }

        public static void replaceBlock(ModelBakeEvent event, BlockDrawersExtended block) {
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                ModelResourceLocation modelResource = BlockModelShapes.func_209554_c((BlockState)state);
                IBakedModel parentModel = event.getModelManager().func_174953_a(modelResource);
                if (parentModel == null || parentModel == event.getModelManager().func_174951_a()) continue;
                if (block.isHalfDepth()) {
                    event.getModelRegistry().put(modelResource, new Model2.HalfModel(parentModel));
                    continue;
                }
                event.getModelRegistry().put(modelResource, new Model2.FullModel(parentModel));
            }
        }

        public static void replaceBlock(ModelBakeEvent event, BlockMoreDrawers block) {
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                ModelResourceLocation modelResource = BlockModelShapes.func_209554_c((BlockState)state);
                IBakedModel parentModel = event.getModelManager().func_174953_a(modelResource);
                if (parentModel == null || parentModel == event.getModelManager().func_174951_a()) continue;
                if (block.isHalfDepth()) {
                    event.getModelRegistry().put(modelResource, new Model2.HalfModel(parentModel));
                    continue;
                }
                event.getModelRegistry().put(modelResource, new Model2.FullModel(parentModel));
            }
        }

        public static abstract class Model2
        implements IDynamicBakedModel {
            protected final IBakedModel mainModel;
            protected final Map<Direction, IBakedModel> lockOverlay;
            protected final Map<Direction, IBakedModel> voidOverlay;
            protected final Map<Direction, IBakedModel> shroudOverlay;
            protected final Map<Direction, IBakedModel> indicator1Overlay;
            protected final Map<Direction, IBakedModel> indicator2Overlay;
            protected final Map<Direction, IBakedModel> indicator4Overlay;
            protected final Map<Direction, IBakedModel> indicatorCompOverlay;

            private Model2(IBakedModel mainModel, Map<Direction, IBakedModel> lockOverlay, Map<Direction, IBakedModel> voidOverlay, Map<Direction, IBakedModel> shroudOverlay, Map<Direction, IBakedModel> indicator1Overlay, Map<Direction, IBakedModel> indicator2Overlay, Map<Direction, IBakedModel> indicator4Overlay, Map<Direction, IBakedModel> indicatorComp) {
                this.mainModel = mainModel;
                this.lockOverlay = lockOverlay;
                this.voidOverlay = voidOverlay;
                this.shroudOverlay = shroudOverlay;
                this.indicator1Overlay = indicator1Overlay;
                this.indicator2Overlay = indicator2Overlay;
                this.indicator4Overlay = indicator4Overlay;
                this.indicatorCompOverlay = indicatorComp;
            }

            public boolean func_230044_c_() {
                return this.mainModel.func_230044_c_();
            }

            @Nonnull
            public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
                ArrayList quads = Lists.newArrayList();
                quads.addAll(this.mainModel.getQuads(state, side, rand, extraData));
                if (state != null && extraData.hasProperty(TileEntityDrawers.ATTRIBUTES)) {
                    IDrawerAttributes attr = (IDrawerAttributes)extraData.getData(TileEntityDrawers.ATTRIBUTES);
                    Direction dir = (Direction)state.func_177229_b((Property)BlockDrawersExtended.field_185512_D);
                    if (attr.isItemLocked(LockAttribute.LOCK_EMPTY) || attr.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                        quads.addAll(this.lockOverlay.get(dir).getQuads(state, side, rand, extraData));
                    }
                    if (attr.isVoid()) {
                        quads.addAll(this.voidOverlay.get(dir).getQuads(state, side, rand, extraData));
                    }
                    if (attr.isConcealed()) {
                        quads.addAll(this.shroudOverlay.get(dir).getQuads(state, side, rand, extraData));
                    }
                    if (attr.hasFillLevel()) {
                        Block block = state.func_177230_c();
                        if (block instanceof BlockCompDrawers) {
                            quads.addAll(this.indicatorCompOverlay.get(dir).getQuads(state, side, rand, extraData));
                        } else if (block instanceof BlockDrawersExtended) {
                            int count = ((BlockDrawersExtended)block).getDrawerCount();
                            if (count == 1) {
                                quads.addAll(this.indicator1Overlay.get(dir).getQuads(state, side, rand, extraData));
                            } else if (count == 2) {
                                quads.addAll(this.indicator2Overlay.get(dir).getQuads(state, side, rand, extraData));
                            } else if (count == 4) {
                                quads.addAll(this.indicator4Overlay.get(dir).getQuads(state, side, rand, extraData));
                            }
                        }
                    }
                }
                return quads;
            }

            public boolean func_177555_b() {
                return this.mainModel.func_177555_b();
            }

            public boolean func_177556_c() {
                return this.mainModel.func_177556_c();
            }

            public boolean func_188618_c() {
                return this.mainModel.func_188618_c();
            }

            public TextureAtlasSprite func_177554_e() {
                return this.mainModel.func_177554_e();
            }

            public ItemOverrideList func_188617_f() {
                return this.mainModel.func_188617_f();
            }

            public static class HalfModel
            extends Model2 {
                HalfModel(IBakedModel mainModel) {
                    super(mainModel, lockOverlaysHalf, voidOverlaysHalf, shroudOverlaysHalf, indicator1Half, indicator2Half, indicator4Half, indicatorComp);
                }
            }

            public static class FullModel
            extends Model2 {
                FullModel(IBakedModel mainModel) {
                    super(mainModel, lockOverlaysFull, voidOverlaysFull, shroudOverlaysFull, indicator1Full, indicator2Full, indicator4Full, indicatorComp);
                }
            }
        }
    }
}

