/*
 * Decompiled with CFR 0.152.
 */
package com.rydelfox.morestoragedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.rydelfox.morestoragedrawers.block.tile.Tiles;
import com.rydelfox.morestoragedrawers.network.ItemUpdateMessage;
import com.rydelfox.morestoragedrawers.network.MoreStorageDrawersPacketHandler;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;

public class TileEntityDrawersMore
extends TileEntityDrawers {
    @CapabilityInject(value=IDrawerAttributes.class)
    static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = null;
    private long lastClickTime;
    private UUID lastClickUUID;

    public TileEntityDrawersMore(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public static TileEntityDrawersMore createEntity(int slotCount) {
        switch (slotCount) {
            case 1: {
                return new Slot1();
            }
            case 2: {
                return new Slot2();
            }
            case 4: {
                return new Slot4();
            }
        }
        return null;
    }

    protected void syncClientItem(int slot, ItemStack item) {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            return;
        }
        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 500.0, this.func_145831_w().func_234923_W_());
        MoreStorageDrawersPacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> point), (Object)new ItemUpdateMessage(this.func_174877_v(), slot, item));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientUpdateItem(int slot, ItemStack item) {
        if (!this.func_145831_w().field_72995_K) {
            return;
        }
        Minecraft.func_71410_x().func_212871_a_(() -> this.clientUpdateItemAsync(slot, item));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientUpdateItemAsync(int slot, ItemStack item) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (drawer.isEnabled() && drawer.getStoredItemPrototype() != item) {
            drawer.setStoredItem(item);
        }
    }

    public IDrawerGroup getGroup() {
        return null;
    }

    private class StandardDrawerData
    extends StandardDrawerGroup.DrawerData {
        private int slot;

        public StandardDrawerData(StandardDrawerGroup group, int slot) {
            super(group);
            this.slot = slot;
        }

        protected int getStackCapacity() {
            return TileEntityDrawersMore.this.upgrades().getStorageMultiplier() * TileEntityDrawersMore.this.getEffectiveDrawerCapacity();
        }

        protected void onItemChanged() {
            DrawerPopulatedEvent event = new DrawerPopulatedEvent((IDrawer)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (TileEntityDrawersMore.this.func_145831_w() != null && !TileEntityDrawersMore.this.func_145831_w().field_72995_K && !this.getStoredItemPrototype().func_190926_b()) {
                TileEntityDrawersMore.this.syncClientItem(this.slot, this.getStoredItemPrototype());
                TileEntityDrawersMore.this.syncClientCount(this.slot, this.getStoredItemCount());
                TileEntityDrawersMore.this.func_70296_d();
            }
        }

        protected void onAmountChanged() {
            if (TileEntityDrawersMore.this.func_145831_w() != null && !TileEntityDrawersMore.this.func_145831_w().field_72995_K) {
                TileEntityDrawersMore.this.syncClientCount(this.slot, this.getStoredItemCount());
                TileEntityDrawersMore.this.func_70296_d();
            }
        }

        protected IDrawer setStoredItem(@Nonnull ItemStack itemPrototype, boolean notify) {
            if (ItemStackHelper.isStackEncoded((ItemStack)itemPrototype)) {
                itemPrototype = ItemStackHelper.decodeItemStackPrototype((ItemStack)itemPrototype);
            }
            if ((itemPrototype = ItemStackHelper.getItemPrototype((ItemStack)itemPrototype)).func_190926_b()) {
                this.reset(notify);
                return this;
            }
            this.setStoredItemRaw(itemPrototype);
            this.forceUpdate();
            return this;
        }

        public void setStoredItemCount(int amount) {
            this.setStoredItemCount(amount, true);
        }

        protected void setStoredItemCount(int amount, boolean notify) {
            if (this.getStoredItemPrototype().func_190926_b() || this.getStoredItemCount() == amount) {
                return;
            }
            if (this.getRemainingCapacity() == Integer.MAX_VALUE) {
                return;
            }
            super.setStoredItemCount(amount, notify);
            this.forceUpdate();
        }

        protected void forceUpdate() {
            TileEntityDrawersMore.this.putItemsIntoSlot(this.slot, ItemStack.field_190927_a, 0);
            if (!TileEntityDrawersMore.this.func_145831_w().field_72995_K) {
                TileEntityDrawersMore.this.syncClientItem(this.slot, this.getStoredItemPrototype());
                TileEntityDrawersMore.this.syncClientCount(this.slot, this.getStoredItemCount());
            }
        }
    }

    private class GroupData
    extends StandardDrawerGroup {
        private final LazyOptional<?> attributesHandler;

        public GroupData(int slotCount) {
            super(slotCount);
            this.attributesHandler = LazyOptional.of(() -> ((TileEntityDrawersMore)TileEntityDrawersMore.this).getDrawerAttributes());
        }

        @Nonnull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            return new StandardDrawerData(this, slot);
        }

        public boolean isGroupValid() {
            return TileEntityDrawersMore.this.isGroupValid();
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == DRAWER_ATTRIBUTES_CAPABILITY) {
                return this.attributesHandler.cast();
            }
            return super.getCapability(capability, facing);
        }
    }

    public static class Slot4
    extends TileEntityDrawersMore {
        private GroupData groupData = new GroupData(4);

        public Slot4() {
            super(Tiles.Tile.MORE_DRAWERS_4);
            this.groupData.setCapabilityProvider((ICapabilityProvider)this);
            this.injectPortableData((TileDataShim)this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends TileEntityDrawersMore {
        private GroupData groupData = new GroupData(2);

        public Slot2() {
            super(Tiles.Tile.MORE_DRAWERS_2);
            this.groupData.setCapabilityProvider((ICapabilityProvider)this);
            this.injectPortableData((TileDataShim)this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot1
    extends TileEntityDrawersMore {
        private GroupData groupData = new GroupData(1);

        public Slot1() {
            super(Tiles.Tile.MORE_DRAWERS_1);
            this.groupData.setCapabilityProvider((ICapabilityProvider)this);
            this.injectPortableData((TileDataShim)this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }
}

