/*
 * Decompiled with CFR 0.152.
 */
package com.rydelfox.morestoragedrawers.block;

import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.rydelfox.morestoragedrawers.MoreCreative;
import com.rydelfox.morestoragedrawers.MoreStorageDrawers;
import com.rydelfox.morestoragedrawers.block.BlockMoreDrawers;
import com.rydelfox.morestoragedrawers.block.EnumMod;
import com.rydelfox.morestoragedrawers.block.tile.TileEntityDrawersMore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum DrawerMaterial implements IStringSerializable
{
    DEFAULT("none", "default", "NO MATERIAL", 0, null),
    ARSNOUVEAU_ARCHWOOD("ars_nouveau", "archwood", "Archwood", 1, "archwood_planks", "archwood_slab"),
    ASTRALSORCERY_INFUSED("astralsorcery", "infused", "Infused", 2, "infused_wood_planks", "infused_wood_slab", 6, 11, 0),
    BOTANIA_LIVINGWOOD("botania", "livingwood", "Livingwood", 3, "livingwood_planks", "livingwood_planks_slab"),
    BOTANIA_MOSSY_LIVINGWOOD("botania", "mossy_livingwood", "Mossy Livingwood", 4, "mossy_livingwood_planks"),
    BOTANIA_DREAMWOOD("botania", "dreamwood", "Dreamwood", 5, "dreamwood_planks", "dreamwood_planks_slab"),
    BOTANIA_MOSSY_DREAMWOOD("botania", "mossy_dreamwood", "Mossy Dreamwood", 6, "mossy_dreamwood_planks"),
    BOTANIA_SHIMMERWOOD("botania", "shimmerwood", "Shimmerwood", 7, "shimmerwood_planks", "shimmerwood_planks_slab"),
    EIDOLON_POLISHED("eidolon", "polished", "Polished", 8, "polished_planks", "polished_planks_slab", 4, 5, 0),
    HEXBLADES_DARK_POLISHED("hexblades", "dark_polished", "Dark Polished", 9, "dark_polished_planks", "dark_polished_planks_slab", 4, 5, 0),
    NATURESAURA_ANCIENT("naturesaura", "ancient", "Ancient", 10, "ancient_planks", "ancient_slab"),
    TWILIGHTFOREST_TOWER("twilightforest", "tower", "Towerwood", 11, "tower_wood", null, 25, 20, 0),
    TWILIGHTFOREST_TWILIGHT("twilightforest", "twilight", "Twilight Oak", 12, "twilight_oak_planks", "twilight_oak_slab"),
    TWILIGHTFOREST_CANOPY("twilightforest", "canopy", "Canopy", 13, "canopy_planks", "canopy_slab"),
    TWILIGHTFOREST_MANGROVE("twilightforest", "mangrove", "Mangrove", 14, "mangrove_planks", "mangrove_slab"),
    TWILIGHTFOREST_DARK("twilightforest", "dark", "Darkwood", 15, "dark_planks", "dark_slab"),
    TWILIGHTFOREST_TIME("twilightforest", "time", "Timewood", 16, "time_planks", "time_slab"),
    TWILIGHTFOREST_TRANS("twilightforest", "trans", "Transwood", 17, "trans_planks", "trans_slab"),
    TWILIGHTFOREST_MINE("twilightforest", "mine", "Minewood", 18, "mine_planks", "mine_slab"),
    TWILIGHTFOREST_SORT("twilightforest", "sort", "Sortingwood", 19, "sort_planks", "sort_slab"),
    BIOMESOPLENTY_FIR("biomesoplenty", "fir", "Fir", 20, "fir_planks", "fir_slab"),
    BIOMESOPLENTY_REDWOOD("biomesoplenty", "redwood", "Redwood", 21, "redwood_planks", "redwood_slab"),
    BIOMESOPLENTY_CHERRY("biomesoplenty", "cherry", "Cherry", 22, "cherry_planks", "cherry_slab"),
    BIOMESOPLENTY_MAHOGANY("biomesoplenty", "mahogany", "Mahogany", 23, "mahogany_planks", "mahogany_slab"),
    BIOMESOPLENTY_JACARANDA("biomesoplenty", "jacaranda", "Jacaranda", 24, "jacaranda_planks", "jacaranda_slab"),
    BIOMESOPLENTY_PALM("biomesoplenty", "palm", "Palm", 25, "palm_planks", "palm_slab"),
    BIOMESOPLENTY_WILLOW("biomesoplenty", "willow", "Willow", 26, "willow_planks", "willow_slab"),
    BIOMESOPLENTY_DEAD("biomesoplenty", "dead", "Deadwood", 27, "dead_planks", "dead_slab"),
    BIOMESOPLENTY_MAGIC("biomesoplenty", "magic", "Magic Wood", 28, "magic_planks", "magic_slab"),
    BIOMESOPLENTY_UMBRAN("biomesoplenty", "umbran", "Umbran", 29, "umbran_planks", "umbran_slab"),
    BIOMESOPLENTY_HELLBARK("biomesoplenty", "hellbark", "Hellbark", 30, "hellbark_planks", "hellbark_slab"),
    BETTERENDFORGE_MOSSY_GLOWSHRROM("betterendforge", "mossy_glowshroom", "Mossy Glowshroom", 31, "mossy_glowshroom_planks", "mossy_glowshroom_slab"),
    BETTERENDFORGE_LACUGROVE("betterendforge", "lacugrove", "Lacugrove", 32, "lacugrove_planks", "lacugrove_slab"),
    BETTERENDFORGE_END_LOTUS("betterendforge", "end_lotus", "End Lotus", 33, "end_lotus_planks", "end_lotus_slab"),
    BETTERENDFORGE_PYTHADENDRON("betterendforge", "pythadendron", "Pythadendron", 34, "pythadendron_planks", "pythadendron_slab"),
    BETTERENDFORGE_DRAGON_TREE("betterendforge", "dragon_tree", "Dragon Tree", 35, "dragon_tree_planks", "dragon_tree_slab"),
    BETTERENDFORGE_TENANEA("betterendforge", "tenanea", "Tenanea", 36, "tenanea_planks", "tenanea_slab"),
    BETTERENDFORGE_HELIX_TREE("betterendforge", "helix_tree", "Helix Tree", 37, "helix_tree_planks", "helix_tree_slab"),
    BETTERENDFORGE_UMBRELLA_TREE("betterendforge", "umbrella_tree", "Umbrella Tree", 38, "umbrella_tree_planks", "umbrella_tree_slab"),
    BETTERENDFORGE_JELLYSHROOM("betterendforge", "jellyshroom", "Jellyshroom", 39, "jellyshroom_planks", "jellyshroom_slab"),
    BETTERENDFORGE_LUCERNIA("betterendforge", "lucernia", "Lucernia", 40, "lucernia_planks", "lucernia_slab"),
    DESOLATION_CHARRED("desolation", "charred", "Charred", 41, "charred_planks", "charred_slab", 1, 10, 0),
    BIOMESYOULLGO_ASPEN("byg", "aspen", "Aspen", 42, "aspen_planks", "aspen_slab"),
    BIOMESYOULLGO_BAOBAB("byg", "baobab", "Baobab", 43, "baobab_planks", "baobab_slab"),
    BIOMESYOULLGO_BLUE_ENCHANTED("byg", "blue_enchanted", "Blue Enchanted", 44, "blue_enchanted_planks", "blue_enchanted_slab"),
    BIOMESYOULLGO_BULBIS("byg", "bulbis", "Bulbis", 45, "bulbis_planks", "bulbis_slab"),
    BIOMESYOULLGO_CHERRY("byg", "cherry", "Cherry", 46, "cherry_planks", "cherry_slab"),
    BIOMESYOULLGO_CIKA("byg", "cika", "Cika", 47, "cika_planks", "cika_slab"),
    BIOMESYOULLGO_CYPRESS("byg", "cypress", "Cypress", 48, "cypress_planks", "cypress_slab"),
    BIOMESYOULLGO_EBONY("byg", "ebony", "Ebony", 49, "ebony_planks", "ebony_slab"),
    BIOMESYOULLGO_ETHER("byg", "ether", "Ether", 50, "ether_planks", "ether_slab"),
    BIOMESYOULLGO_FIR("byg", "fir", "Fir", 51, "fir_planks", "fir_slab"),
    BIOMESYOULLGO_GREEN_ENCHANTED("byg", "green_enchanted", "Green Enchanted", 52, "green_enchanted_planks", "green_enchanted_slab"),
    BIOMESYOULLGO_HOLLY("byg", "holly", "Holly", 53, "holly_planks", "holly_slab"),
    BIOMESYOULLGO_IMPARIUS("byg", "imparius", "Imparius", 54, "imparius_planks", "imparius_slab"),
    BIOMESYOULLGO_JACARANDA("byg", "jacaranda", "Jacaranda", 53, "jacaranda_planks", "jacaranda_slab"),
    BIOMESYOULLGO_LAMENT("byg", "lament", "Lament", 54, "lament_planks", "lament_slab"),
    BIOMESYOULLGO_MAHOGANY("byg", "mahogany", "Mahogany", 55, "mahogany_planks", "mahogany_slabs"),
    BIOMESYOULLGO_MANGROVE("byg", "mangrove", "Mangrove", 56, "mangrove_planks", "mangrove_slab"),
    BIOMESYOULLGO_MAPLE("byg", "maple", "Maple", 57, "maple_planks", "maple_slab"),
    BIOMESYOULLGO_NIGHTSHADE("byg", "nightshade", "Nightshade", 58, "nightshade_planks", "nightshade_slab"),
    BIOMESYOULLGO_PALM("byg", "palm", "Palm", 59, "palm_planks", "palm_slab"),
    BIOMESYOULLGO_PINE("byg", "pine", "Pine", 60, "pine_planks", "pine_slab"),
    BIOMESYOULLGO_RAINBOW_EUCALYPTUS("byg", "rainbow_eucalyptus", "Rainbow Eucalyptus", 61, "rainbow_eucalyptus_planks", "rainbow_eucalyptus_slab"),
    BIOMESYOULLGO_REDWOOD("byg", "redwood", "Redwood", 62, "redwood_planks", "redwood_slab"),
    BIOMESYOULLGO_SKYRIS("byg", "skyris", "Skyris", 63, "skyris_planks", "skyris_slab"),
    BIOMESYOULLGO_WILLOW("byg", "willow", "Willow", 64, "willow_planks", "willow_slab"),
    BIOMESYOULLGO_WITCH_HAZEL("byg", "witch_hazel", "Witch Hazel", 65, "witch_hazel_planks", "witch_hazel_slab"),
    BIOMESYOULLGO_ZELKOVA("byg", "zelkova", "Zelkova", 66, "zelkova_planks", "zelkova_slab"),
    BIOMESYOULLGO_SYTHIAN("byg", "sythian", "Sythian", 67, "sythian_planks", "sythian_slab"),
    BIOMESYOULLGO_EMBUR("byg", "embur", "Embur", 68, "embur_planks", "embur_slab"),
    OUTEREND_AZURE("outer_end", "azure", "Azure", 69, "azure_planks", "azure_slab"),
    WILDNATURE_ORANGE_BIND("wild_nature", "orange_bind", "Orange Bind", 70, "orange_bind_wood_planks", "orange_bind_wood_slab"),
    WILDNATURE_END_WOOD("wild_nature", "end_wood", "End Wood", 71, "end_wood_planks", "end_wood_slab"),
    WILDNATURE_DEATH_WOOD("wild_nature", "death_wood", "Death Wood", 72, "death_wood_planks", "death_wood_slab"),
    WILDNATURE_SAKURA("wild_nature", "sakura", "Sakura", 73, "sakura_planks", "sakura_slab"),
    WILDNATURE_LAVENDER("wild_nature", "lavender", "Lavender", 74, "sakura_slab", "lavender_slab"),
    WILDNATURE_REDWOOD("wild_nature", "redwood", "Redwood", 75, "redwood_planks", "redwood_slab");

    private static final Map<ResourceLocation, DrawerMaterial> RESOURCE_LOOKUP;
    private static final Map<Integer, DrawerMaterial> INDEX_LOOKUP;
    private final String namespace;
    private final String name;
    private final String englishName;
    private final ResourceLocation resource;
    private final ResourceLocation plankResource;
    private final ResourceLocation slabResource;
    private final int index;
    private final int hardness;
    private final int blastResistance;
    private final int light;
    private RegistryObject<Block> regBlockTrim = null;
    private RegistryObject<Block> regFullOne = null;
    private RegistryObject<Block> regFullTwo = null;
    private RegistryObject<Block> regFullFour = null;
    private RegistryObject<Block> regHalfOne = null;
    private RegistryObject<Block> regHalfTwo = null;
    private RegistryObject<Block> regHalfFour = null;
    private Block blockTrim = null;
    private Block blockFullOne = null;
    private Block blockFullTwo = null;
    private Block blockFullFour = null;
    private Block blockHalfOne = null;
    private Block blockHalfTwo = null;
    private Block blockHalfFour = null;
    private Item itemTrim = null;
    private Item itemFullOne = null;
    private Item itemFullTwo = null;
    private Item itemFullFour = null;
    private Item itemHalfOne = null;
    private Item itemHalfTwo = null;
    private Item itemHalfFour = null;
    private TileEntityDrawersMore tileFullOne = null;
    private TileEntityDrawersMore tileFullTwo = null;
    private TileEntityDrawersMore tileFullFour = null;
    private TileEntityDrawersMore tileHalfOne = null;
    private TileEntityDrawersMore tileHalfTwo = null;
    private TileEntityDrawersMore tileHalfFour = null;

    private DrawerMaterial(String namespace, String name, String englishName, int index, String blockId) {
        this(namespace, name, englishName, index, blockId, null);
    }

    private DrawerMaterial(String namespace, String name, String englishName, int index, String plankId, String slabId) {
        this(namespace, name, englishName, index, plankId, slabId, 5, 5, 0);
    }

    private DrawerMaterial(String namespace, String name, String englishName, int index, String plankId, String slabId, int hardness, int blastResistance, int light) {
        this.namespace = namespace;
        this.name = name;
        this.englishName = englishName;
        this.plankResource = plankId != null ? new ResourceLocation(namespace, plankId) : null;
        this.slabResource = slabId != null ? new ResourceLocation(namespace, slabId) : null;
        this.resource = new ResourceLocation(namespace, name);
        this.index = index;
        this.hardness = hardness;
        this.blastResistance = blastResistance;
        this.light = light;
    }

    @Nonnull
    public String getNamespace() {
        return this.resource.func_110624_b();
    }

    @Nonnull
    public String getPath() {
        return this.resource.func_110623_a();
    }

    @Nonnull
    public String func_176610_l() {
        return this.resource.toString();
    }

    public EnumMod getMod() {
        return EnumMod.byId(this.namespace);
    }

    @Nonnull
    public ResourceLocation getResource() {
        return this.resource;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String prefix() {
        return this.namespace + "_" + this.name;
    }

    public ResourceLocation getPlankResource() {
        return this.plankResource;
    }

    public ResourceLocation getSlabResource() {
        return this.slabResource;
    }

    public int getIndex() {
        return this.index;
    }

    public int getGroupIndex() {
        return this.index / 16;
    }

    public int getGroupMeta() {
        return this.index % 16;
    }

    public int getHardness() {
        return this.hardness;
    }

    public int getBlastResistance() {
        return this.blastResistance;
    }

    public int getLight() {
        return this.light;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public BlockMoreDrawers getDrawer(int slots, boolean halfDepth) {
        if (halfDepth) {
            switch (slots) {
                case 4: {
                    return (BlockMoreDrawers)this.blockHalfFour;
                }
                case 2: {
                    return (BlockMoreDrawers)this.blockHalfTwo;
                }
            }
            return (BlockMoreDrawers)this.blockHalfOne;
        }
        switch (slots) {
            case 4: {
                return (BlockMoreDrawers)this.blockFullFour;
            }
            case 2: {
                return (BlockMoreDrawers)this.blockFullTwo;
            }
        }
        return (BlockMoreDrawers)this.blockFullOne;
    }

    public BlockTrim getTrim() {
        return (BlockTrim)this.blockTrim;
    }

    public List<Block> getBlocks() {
        return this.getBlocks(true);
    }

    public List<Block> getBlocks(boolean includeTrim) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        blocks.add(this.blockFullOne);
        blocks.add(this.blockFullTwo);
        blocks.add(this.blockFullFour);
        blocks.add(this.blockHalfOne);
        blocks.add(this.blockHalfTwo);
        blocks.add(this.blockHalfFour);
        if (includeTrim) {
            blocks.add(this.blockTrim);
        }
        return blocks;
    }

    public List<Item> getItems() {
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(this.itemFullOne);
        items.add(this.itemFullTwo);
        items.add(this.itemFullFour);
        items.add(this.itemHalfOne);
        items.add(this.itemHalfTwo);
        items.add(this.itemHalfFour);
        items.add(this.itemTrim);
        return items;
    }

    public void registerBlocks(IForgeRegistry<Block> registry) {
        if (this == DEFAULT) {
            return;
        }
        if (this.blockTrim != null) {
            throw new IllegalStateException(this.getEnglishName() + " blocks have already been registered!");
        }
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).harvestTool(ToolType.AXE).func_200948_a((float)this.hardness, (float)this.blastResistance).func_235838_a_(p1 -> this.light).func_235842_b_((p1, p2, p3) -> false).func_235828_a_((p1, p2, p3) -> false);
        MoreStorageDrawers.logInfo("Registering blocks for " + this.englishName);
        this.blockTrim = (Block)new BlockTrim(properties).setRegistryName(this.namespace + "_" + this.name + "_trim");
        this.blockFullOne = (Block)new BlockMoreDrawers(1, false, properties).setRegistryName(this.namespace + "_" + this.name + "_full_1");
        this.blockFullTwo = (Block)new BlockMoreDrawers(2, false, properties).setRegistryName(this.namespace + "_" + this.name + "_full_2");
        this.blockFullFour = (Block)new BlockMoreDrawers(4, false, properties).setRegistryName(this.namespace + "_" + this.name + "_full_4");
        this.blockHalfOne = (Block)new BlockMoreDrawers(1, true, properties).setRegistryName(this.namespace + "_" + this.name + "_half_1");
        this.blockHalfTwo = (Block)new BlockMoreDrawers(2, true, properties).setRegistryName(this.namespace + "_" + this.name + "_half_2");
        this.blockHalfFour = (Block)new BlockMoreDrawers(4, true, properties).setRegistryName(this.namespace + "_" + this.name + "_half_4");
        registry.register((IForgeRegistryEntry)this.blockTrim);
        registry.register((IForgeRegistryEntry)this.blockFullOne);
        registry.register((IForgeRegistryEntry)this.blockFullTwo);
        registry.register((IForgeRegistryEntry)this.blockFullFour);
        registry.register((IForgeRegistryEntry)this.blockHalfOne);
        registry.register((IForgeRegistryEntry)this.blockHalfTwo);
        registry.register((IForgeRegistryEntry)this.blockHalfFour);
    }

    public void registerItems(IForgeRegistry<Item> registry) {
        if (this == DEFAULT) {
            return;
        }
        if (this.itemTrim != null) {
            throw new IllegalStateException(this.getEnglishName() + " items have already been registered!");
        }
        if (this.blockTrim == null) {
            throw new IllegalStateException("Blocks must be registered before registering items!");
        }
        this.itemTrim = (Item)new BlockItem(this.blockTrim, new Item.Properties().func_200916_a(MoreCreative.TAB)).setRegistryName(this.blockTrim.getRegistryName());
        this.itemFullOne = (Item)new BlockItem(this.blockFullOne, new Item.Properties().func_200916_a(MoreCreative.TAB)).setRegistryName(this.blockFullOne.getRegistryName());
        this.itemFullTwo = (Item)new BlockItem(this.blockFullTwo, new Item.Properties().func_200916_a(MoreCreative.TAB)).setRegistryName(this.blockFullTwo.getRegistryName());
        this.itemFullFour = (Item)new BlockItem(this.blockFullFour, new Item.Properties().func_200916_a(MoreCreative.TAB)).setRegistryName(this.blockFullFour.getRegistryName());
        this.itemHalfOne = (Item)new BlockItem(this.blockHalfOne, new Item.Properties().func_200916_a(MoreCreative.TAB)).setRegistryName(this.blockHalfOne.getRegistryName());
        this.itemHalfTwo = (Item)new BlockItem(this.blockHalfTwo, new Item.Properties().func_200916_a(MoreCreative.TAB)).setRegistryName(this.blockHalfTwo.getRegistryName());
        this.itemHalfFour = (Item)new BlockItem(this.blockHalfFour, new Item.Properties().func_200916_a(MoreCreative.TAB)).setRegistryName(this.blockHalfFour.getRegistryName());
        registry.register((IForgeRegistryEntry)this.itemTrim);
        registry.register((IForgeRegistryEntry)this.itemFullOne);
        registry.register((IForgeRegistryEntry)this.itemFullTwo);
        registry.register((IForgeRegistryEntry)this.itemFullFour);
        registry.register((IForgeRegistryEntry)this.itemHalfOne);
        registry.register((IForgeRegistryEntry)this.itemHalfTwo);
        registry.register((IForgeRegistryEntry)this.itemHalfFour);
    }

    @Nonnull
    public static DrawerMaterial byResource(String resource) {
        DrawerMaterial variant = RESOURCE_LOOKUP.get(new ResourceLocation(resource));
        return variant != null ? variant : DEFAULT;
    }

    @Nonnull
    public static DrawerMaterial byGroupMeta(int group, int meta) {
        DrawerMaterial varient = INDEX_LOOKUP.get(group * 16 + meta);
        return varient != null ? varient : DEFAULT;
    }

    static {
        RESOURCE_LOOKUP = new HashMap<ResourceLocation, DrawerMaterial>();
        INDEX_LOOKUP = new HashMap<Integer, DrawerMaterial>();
        for (DrawerMaterial varient : DrawerMaterial.values()) {
            RESOURCE_LOOKUP.put(varient.getResource(), varient);
            INDEX_LOOKUP.put(varient.getIndex(), varient);
        }
    }

    private static class ID {
        public static final String DEFAULT = "none";
        public static final String ARSNOUVEAU = "ars_nouveau";
        public static final String ASTRALSORCERY = "astralsorcery";
        public static final String BOTANIA = "botania";
        public static final String EIDOLON = "eidolon";
        public static final String HEXBLADES = "hexblades";
        public static final String NATURESAURA = "naturesaura";
        public static final String TWILIGHTFOREST = "twilightforest";
        public static final String BIOMESOPLENTY = "biomesoplenty";
        public static final String BETTERENDFORGE = "betterendforge";
        public static final String DESOLATION = "desolation";
        public static final String BIOMESYOULLGO = "byg";
        public static final String OUTEREND = "outer_end";
        public static final String TRAVERSE = "traverse";
        public static final String WILDNATURE = "wild_nature";

        private ID() {
        }
    }
}

