/*
 * Decompiled with CFR 0.152.
 */
package com.rydelfox.morestoragedrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.config.ClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers1;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers2;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers4;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.rydelfox.morestoragedrawers.MoreStorageDrawers;
import com.rydelfox.morestoragedrawers.block.tile.TileEntityDrawersMore;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class BlockDrawersExtended
extends BlockDrawers {
    private static final VoxelShape AABB_FULL = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_NORTH_FULL = VoxelShapes.func_197878_a((VoxelShape)AABB_FULL, (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape AABB_SOUTH_FULL = VoxelShapes.func_197878_a((VoxelShape)AABB_FULL, (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape AABB_WEST_FULL = VoxelShapes.func_197878_a((VoxelShape)AABB_FULL, (VoxelShape)Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape AABB_EAST_FULL = VoxelShapes.func_197878_a((VoxelShape)AABB_FULL, (VoxelShape)Block.func_208617_a((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape AABB_NORTH_HALF = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_SOUTH_HALF = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape AABB_WEST_HALF = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_EAST_HALF = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private long ignoreEventTime;
    private static final ThreadLocal<Boolean> inTileLookup = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public BlockDrawersExtended(int drawerCount, boolean halfDepth, int storageUnits, AbstractBlock.Properties properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initDynamic() {
    }

    public AxisAlignedBB[] getSlotGeometry() {
        return this.slotGeometry;
    }

    public AxisAlignedBB getSlotGeometry(int slot) {
        return this.slotGeometry[slot];
    }

    public void setSlotGeometry(int slot, AxisAlignedBB axis) {
        this.slotGeometry[slot] = new AxisAlignedBB(axis.field_72340_a, axis.field_72338_b, axis.field_72339_c, axis.field_72336_d, axis.field_72337_e, axis.field_72334_f);
    }

    public AxisAlignedBB[] getCountGeometry() {
        return this.countGeometry;
    }

    public AxisAlignedBB getCountGeometry(int slot) {
        return this.countGeometry[slot];
    }

    public void setCountGeometry(int slot, AxisAlignedBB axis) {
        this.countGeometry[slot] = new AxisAlignedBB(axis.field_72340_a, axis.field_72338_b, axis.field_72339_c, axis.field_72336_d, axis.field_72337_e, axis.field_72334_f);
    }

    public AxisAlignedBB[] getLabelGeometry() {
        return this.labelGeometry;
    }

    public AxisAlignedBB getLabelGeometry(int slot) {
        return this.labelGeometry[slot];
    }

    public void setLabelGeometry(int slot, AxisAlignedBB axis) {
        this.labelGeometry[slot] = new AxisAlignedBB(axis.field_72340_a, axis.field_72338_b, axis.field_72339_c, axis.field_72336_d, axis.field_72337_e, axis.field_72334_f);
    }

    public AxisAlignedBB[] getIndGeometry() {
        return this.indGeometry;
    }

    public AxisAlignedBB getIndGeometry(int slot) {
        return this.indGeometry[slot];
    }

    public void setIndGeometry(int slot, AxisAlignedBB axis) {
        this.indGeometry[slot] = new AxisAlignedBB(axis.field_72340_a, axis.field_72338_b, axis.field_72339_c, axis.field_72336_d, axis.field_72337_e, axis.field_72334_f);
    }

    public AxisAlignedBB[] getIndBaseGeometry() {
        return this.indBaseGeometry;
    }

    public AxisAlignedBB getIndBaseGeometry(int slot) {
        return this.indBaseGeometry[slot];
    }

    public void setIndBaseGeometry(int slot, AxisAlignedBB axis) {
        this.indBaseGeometry[slot] = new AxisAlignedBB(axis.field_72340_a, axis.field_72338_b, axis.field_72339_c, axis.field_72336_d, axis.field_72337_e, axis.field_72334_f);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack item = player.func_184586_b(hand);
        if (!(this.getTileEntitySafe(world, pos) instanceof TileEntityDrawersMore)) {
            return super.func_225533_a_(state, world, pos, player, hand, hit);
        }
        if (hand == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K && Util.func_211177_b() == this.ignoreEventTime) {
            this.ignoreEventTime = 0L;
            return ActionResultType.PASS;
        }
        final TileEntityDrawersMore tileDrawers = (TileEntityDrawersMore)this.getTileEntitySafe(world, pos);
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info("BlockDrawers.onBlockActivated");
            StorageDrawers.log.info(item.func_190926_b() ? "  null item" : "  " + item.toString());
        }
        if (!item.func_190926_b()) {
            if (item.func_77973_b() instanceof ItemKey) {
                return ActionResultType.PASS;
            }
            if (item.func_77973_b() instanceof ItemUpgrade) {
                if (!tileDrawers.upgrades().canAddUpgrade(item)) {
                    if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.storagedrawers.cannot_add_upgrade"), true);
                    }
                    return ActionResultType.PASS;
                }
                if (!tileDrawers.upgrades().addUpgrade(item)) {
                    if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.storagedrawers.max_upgrades"), true);
                    }
                    return ActionResultType.PASS;
                }
                world.func_184138_a(pos, state, state, 3);
                if (!player.func_184812_l_()) {
                    item.func_190918_g(1);
                    if (item.func_190916_E() <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        } else if (item.func_190926_b() && player.func_225608_bj_()) {
            MoreStorageDrawers.logInfo("Empty hand and sneaking");
            if (((Boolean)CommonConfig.GENERAL.enableUI.get()).booleanValue() && !world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent(BlockDrawersExtended.this.func_149739_a());
                    }

                    @Nullable
                    public Container createMenu(int windowId, PlayerInventory playerInv, PlayerEntity playerEntity) {
                        if (BlockDrawersExtended.super.getDrawerCount() == 1) {
                            return new ContainerDrawers1(windowId, playerInv, (TileEntityDrawers)tileDrawers);
                        }
                        if (BlockDrawersExtended.super.getDrawerCount() == 2) {
                            return new ContainerDrawers2(windowId, playerInv, (TileEntityDrawers)tileDrawers);
                        }
                        if (BlockDrawersExtended.super.getDrawerCount() == 4) {
                            return new ContainerDrawers4(windowId, playerInv, (TileEntityDrawers)tileDrawers);
                        }
                        return null;
                    }
                }, extraData -> extraData.func_179255_a(pos));
                return ActionResultType.SUCCESS;
            }
        }
        if (state.func_177229_b((Property)field_185512_D) != hit.func_216354_b()) {
            return ActionResultType.PASS;
        }
        int slot = this.getDrawerSlot(hit);
        IDrawer drawer = tileDrawers.getGroup().getDrawer(slot);
        tileDrawers.interactPutItemsIntoSlot(slot, player);
        if (item.func_190926_b()) {
            player.func_184611_a(hand, ItemStack.field_190927_a);
        }
        drawer = tileDrawers.getGroup().getDrawer(slot);
        return ActionResultType.SUCCESS;
    }

    private Vector3d normalizeHitVec(Vector3d hit) {
        return new Vector3d((hit.field_72450_a < 0.0 ? hit.field_72450_a - Math.floor(hit.field_72450_a) : hit.field_72450_a) % 1.0, (hit.field_72448_b < 0.0 ? hit.field_72448_b - Math.floor(hit.field_72448_b) : hit.field_72448_b) % 1.0, (hit.field_72449_c < 0.0 ? hit.field_72449_c - Math.floor(hit.field_72449_c) : hit.field_72449_c) % 1.0);
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn) {
        BlockRayTraceResult rayResult;
        if (!(this.getTileEntitySafe(worldIn, pos) instanceof TileEntityDrawersMore)) {
            super.func_196270_a(state, worldIn, pos, playerIn);
        }
        if (worldIn.field_72995_K) {
            return;
        }
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info("onBlockClicked");
        }
        if ((rayResult = this.rayTraceEyes(worldIn, playerIn, playerIn.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 1.0)).func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        Direction side = rayResult.func_216354_b();
        TileEntityDrawersMore tileDrawers = (TileEntityDrawersMore)this.getTileEntitySafe(worldIn, pos);
        if (state.func_177229_b((Property)field_185512_D) != rayResult.func_216354_b()) {
            return;
        }
        int slot = this.getDrawerSlot(rayResult);
        IDrawer drawer = tileDrawers.getDrawer(slot);
        boolean invertShift = (Boolean)ClientConfig.GENERAL.invertShift.get();
        ItemStack item = playerIn.func_225608_bj_() != invertShift ? tileDrawers.takeItemsFromSlot(slot, drawer.getStoredItemStackSize()) : tileDrawers.takeItemsFromSlot(slot, 1);
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info(item.func_190926_b() ? "  null item" : "  " + item.toString());
        }
        if (!item.func_190926_b()) {
            if (!playerIn.field_71071_by.func_70441_a(item)) {
                this.dropItemStack(worldIn, pos.func_177972_a(side), playerIn, item);
                worldIn.func_184138_a(pos, state, state, 3);
            } else {
                worldIn.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    private void dropItemStack(World world, BlockPos pos, PlayerEntity player, @Nonnull ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.3f), (double)((float)pos.func_177952_p() + 0.5f), stack);
        Vector3d motion = entity.func_213322_ci();
        entity.func_70024_g(-motion.field_72450_a, -motion.field_72448_b, -motion.field_72449_c);
        world.func_217376_c((Entity)entity);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityDrawersMore tile = (TileEntityDrawersMore)this.getTileEntity((IBlockReader)world, pos);
        if (tile != null) {
            // empty if block
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getMainDrop(state, (TileEntityDrawersMore)((Object)builder.func_216019_b(LootParameters.field_216288_h))));
        return items;
    }

    protected ItemStack getMainDrop(BlockState state, TileEntityDrawersMore tile) {
        int i;
        ItemStack drop = new ItemStack((IItemProvider)this);
        if (tile == null) {
            return drop;
        }
        CompoundNBT data = drop.func_77978_p();
        if (data == null) {
            data = new CompoundNBT();
        }
        boolean hasContents = false;
        for (i = 0; i < tile.getGroup().getDrawerCount(); ++i) {
            IDrawer drawer = tile.getGroup().getDrawer(i);
            if (drawer == null || drawer.isEmpty()) continue;
            hasContents = true;
        }
        for (i = 0; i < tile.upgrades().getSlotCount(); ++i) {
            if (tile.upgrades().getUpgrade(i).func_190926_b()) continue;
            hasContents = true;
        }
        if (hasContents) {
            CompoundNBT tiledata = new CompoundNBT();
            tile.func_189515_b(tiledata);
            tiledata.func_82580_o("x");
            tiledata.func_82580_o("y");
            tiledata.func_82580_o("z");
            data.func_218657_a("tile", (INBT)tiledata);
            drop.func_77982_d(data);
        }
        return drop;
    }

    public int func_180656_a(BlockState state, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!this.func_149744_f(state)) {
            return 0;
        }
        TileEntityDrawersMore tile = (TileEntityDrawersMore)this.getTileEntity(blockAccess, pos);
        if (tile == null || !tile.isRedstone()) {
            return 0;
        }
        return tile.getRedstoneLevel();
    }
}

