/*
 * Decompiled with CFR 0.152.
 */
package com.rydelfox.morestoragedrawers;

import com.jaquadro.minecraft.storagedrawers.config.ClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.core.ClientProxy;
import com.jaquadro.minecraft.storagedrawers.core.CommonProxy;
import com.rydelfox.morestoragedrawers.block.EnumMod;
import com.rydelfox.morestoragedrawers.block.tile.Tiles;
import com.rydelfox.morestoragedrawers.client.renderer.TileEntityDrawersRenderer;
import com.rydelfox.morestoragedrawers.core.Registration;
import com.rydelfox.morestoragedrawers.network.MoreStorageDrawersPacketHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="morestoragedrawers")
public class MoreStorageDrawers {
    public static final String MOD_ID = "morestoragedrawers";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean DEBUG = true;
    public static CommonProxy proxy;
    public static CompTierRegistry compRegistry;

    public MoreStorageDrawers() {
        MoreStorageDrawers.logInfo("Loading MoreStorageDrawers");
        proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ClientConfig.spec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CommonConfig.spec);
        MoreStorageDrawers.logLoadedMods();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModQueueEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModConfigEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        MoreStorageDrawersPacketHandler.init();
        compRegistry = new CompTierRegistry();
        compRegistry.initialize();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        Registration.bindRenderTypes();
        MoreStorageDrawers.logInfo("MoreStorageDrawers: Register renderers in clientSetup");
        ClientRegistry.bindTileEntityRenderer(Tiles.Tile.MORE_DRAWERS_1, TileEntityDrawersRenderer::new);
        ClientRegistry.bindTileEntityRenderer(Tiles.Tile.MORE_DRAWERS_2, TileEntityDrawersRenderer::new);
        ClientRegistry.bindTileEntityRenderer(Tiles.Tile.MORE_DRAWERS_4, TileEntityDrawersRenderer::new);
    }

    private void onModQueueEvent(InterModEnqueueEvent event) {
    }

    private void onModConfigEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            // empty if block
        }
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            // empty if block
        }
    }

    public static void logInfo(String info) {
        LOGGER.info(info);
    }

    public static void logLoadedMods() {
        for (EnumMod mod : EnumMod.values()) {
            if (!mod.isLoaded()) continue;
            MoreStorageDrawers.logInfo("MoreStorageDrawers: " + mod.func_176610_l() + " mod loaded");
        }
    }
}

