/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon.color;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.interfaces.ICanMouseDrag;
import com.hrznstudio.titanium.client.screen.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;

public class HuePickerAddon
extends BasicScreenAddon
implements IClickable,
ICanMouseDrag {
    private final Consumer<Float> consumer;
    private float hue;

    protected HuePickerAddon(int posX, int posY, float hue, Consumer<Float> consumer) {
        super(posX, posY);
        this.consumer = consumer;
        this.hue = hue;
    }

    @Override
    public int getXSize() {
        return 146;
    }

    @Override
    public int getYSize() {
        return 8;
    }

    @Override
    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.drawColorBar(stack, this.getPosX() + guiX, this.getPosY() + guiY, this.getXSize(), this.getYSize());
        AssetUtil.drawAsset(stack, screen, provider.getAsset(AssetTypes.HUE_PICKER), guiX + (int)((float)this.getPosX() + this.hue * (float)this.getXSize()) - 3, guiY + this.getPosY() - 3);
    }

    @Override
    public void drawForegroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
    }

    private void drawColorBar(MatrixStack matrix, int x, int y, int width, int height) {
        for (int i = 0; i < width; ++i) {
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(x + i), (int)y, (int)(x + i + 1), (int)(y + height), (int)Color.getHSBColor((float)i / (float)width, 1.0f, 1.0f).getRGB());
        }
    }

    @Override
    public void handleClick(Screen screen, int guiX, int guiY, double mouseX, double mouseY, int button) {
        this.hue = (float)((mouseX - (double)this.getPosX() - (double)guiX) / (double)this.getXSize());
        this.consumer.accept(Float.valueOf(this.hue));
    }

    @Override
    public void drag(int x, int y) {
        this.hue = ((float)x - (float)this.getPosX()) / (float)this.getXSize();
        this.consumer.accept(Float.valueOf(this.hue));
    }

    public void setHue(float hue) {
        this.hue = hue;
    }
}

