/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects.chairs;

import com.mcwfurnitures.kikoz.MacawsFurnitures;
import com.mcwfurnitures.kikoz.objects.FurnitureObject;
import com.mcwfurnitures.kikoz.storage.ChairEntity;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ModernChair
extends FurnitureObject {
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)2.0, (double)12.0, (double)12.0, (double)14.0, (double)18.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)15.0, (double)2.0), Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0), Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)15.0, (double)16.0), Block.func_208617_a((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.func_208617_a((double)14.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)1.0, (double)8.0, (double)0.1, (double)15.0, (double)10.0, (double)15.9), Block.func_208617_a((double)2.0, (double)9.0, (double)1.0, (double)14.0, (double)12.0, (double)15.0)});

    protected void runCalculation(VoxelShape shape) {
        for (Direction direction : Direction.values()) {
            SHAPES.put(direction, MacawsFurnitures.calculateShapes(direction, shape));
        }
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((Property)FACING));
    }

    public ModernChair(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.runCalculation(SHAPE);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        return ChairEntity.create(world, pos, 0.4, playerEntity);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }
}

