/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects;

import com.mcwfurnitures.kikoz.init.TileEntityInit;
import com.mcwfurnitures.kikoz.objects.FurnitureObject;
import com.mcwfurnitures.kikoz.storage.FurnitureTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class WideFurniture
extends FurnitureObject
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    protected static final VoxelShape EW = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NS = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);

    public WideFurniture(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NS;
            }
            case SOUTH: {
                return NS;
            }
            case WEST: {
                return EW;
            }
        }
        return EW;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.FURNITURE_CHEST.get()).func_200968_a();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te;
        if (state.func_177230_c() != newState.func_177230_c() && (te = worldIn.func_175625_s(pos)) instanceof FurnitureTileEntity) {
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((FurnitureTileEntity)te).func_190576_q());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult result) {
        TileEntity tile;
        ItemStack itemstack = player.func_184586_b(handIn);
        if (itemstack != ItemStack.field_190927_a) {
            return ActionResultType.FAIL;
        }
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof FurnitureTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntity)tile), (BlockPos)pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    private BlockState TableState(BlockState state, IWorld world, BlockPos pos) {
        boolean north = world.func_180495_p(pos.func_177978_c()).func_177230_c() == this;
        boolean east = world.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
        boolean south = world.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
        boolean west = world.func_180495_p(pos.func_177976_e()).func_177230_c() == this;
        return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState statetwo, boolean bolen) {
        if (!statetwo.func_203425_a(state.func_177230_c())) {
            this.TableState(state, (IWorld)level, pos);
        }
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, NORTH, EAST, SOUTH, WEST, HINGE, WATERLOGGED});
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction dir, BlockState statetwo, IWorld level, BlockPos pos, BlockPos postwo) {
        return this.TableState(state, level, pos);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.TableState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a()).func_206870_a(HINGE, (Comparable)this.getSide(context))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public void placeAt(IWorld level, BlockPos pos, int num) {
        level.func_180501_a(pos, this.func_176223_P(), num);
    }

    private DoorHingeSide getSide(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_195992_f();
        int j = direction.func_82601_c();
        int k = direction.func_82599_e();
        Vector3d vector3d = context.func_221532_j();
        double d0 = vector3d.field_72450_a - (double)blockpos.func_177958_n();
        double d1 = vector3d.field_72449_c - (double)blockpos.func_177952_p();
        return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
    }

    @Override
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207188_f() : super.func_204507_t(state);
    }
}

