/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import thelm.jaopca.api.resources.IInMemoryResourcePack;

public class InMemoryResourcePack
implements IInMemoryResourcePack {
    private static final Gson GSON = new GsonBuilder().create();
    private final String name;
    private final boolean isHidden;
    private final JsonObject metadata = (JsonObject)new JsonParser().parse("{\"pack_format\":4,\"description\":\"JAOPCA In Memory Resources\"}");
    private final TreeMap<String, Supplier<? extends InputStream>> root = new TreeMap();
    private final TreeMap<ResourceLocation, Supplier<? extends InputStream>> assets = new TreeMap();
    private final TreeMap<ResourceLocation, Supplier<? extends InputStream>> data = new TreeMap();

    public InMemoryResourcePack(String name, boolean isHidden) {
        this.name = name;
        this.isHidden = isHidden;
    }

    @Override
    public IInMemoryResourcePack putInputStream(ResourcePackType type, ResourceLocation location, Supplier<? extends InputStream> streamSupplier) {
        switch (type) {
            case CLIENT_RESOURCES: {
                this.assets.put(location, streamSupplier);
                break;
            }
            case SERVER_DATA: {
                this.data.put(location, streamSupplier);
                break;
            }
        }
        return this;
    }

    @Override
    public IInMemoryResourcePack putInputStreams(ResourcePackType type, Map<ResourceLocation, Supplier<? extends InputStream>> map) {
        switch (type) {
            case CLIENT_RESOURCES: {
                this.assets.putAll(map);
                break;
            }
            case SERVER_DATA: {
                this.data.putAll(map);
                break;
            }
        }
        return this;
    }

    @Override
    public IInMemoryResourcePack putByteArray(ResourcePackType type, ResourceLocation location, byte[] file) {
        return this.putInputStream(type, location, () -> new ByteArrayInputStream(file));
    }

    @Override
    public IInMemoryResourcePack putByteArrays(ResourcePackType type, Map<ResourceLocation, byte[]> map) {
        return this.putInputStreams(type, Maps.transformValues(map, file -> () -> new ByteArrayInputStream((byte[])file)));
    }

    @Override
    public IInMemoryResourcePack putString(ResourcePackType type, ResourceLocation location, String str) {
        return this.putByteArray(type, location, str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public IInMemoryResourcePack putStrings(ResourcePackType type, Map<ResourceLocation, String> map) {
        return this.putByteArrays(type, Maps.transformValues(map, str -> str.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public IInMemoryResourcePack putJson(ResourcePackType type, ResourceLocation location, JsonElement json) {
        return this.putString(type, location, GSON.toJson(json));
    }

    @Override
    public IInMemoryResourcePack putJsons(ResourcePackType type, Map<ResourceLocation, ? extends JsonElement> map) {
        return this.putStrings(type, Maps.transformValues(map, json -> GSON.toJson(json)));
    }

    public InputStream func_195763_b(String fileName) throws IOException {
        if (fileName.contains("/") || fileName.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        if (this.root.containsKey(fileName)) {
            return this.root.get(fileName).get();
        }
        throw new FileNotFoundException(fileName);
    }

    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        TreeMap<ResourceLocation, Supplier<? extends InputStream>> map;
        TreeMap<ResourceLocation, Supplier<? extends InputStream>> treeMap = map = type == ResourcePackType.CLIENT_RESOURCES ? this.assets : this.data;
        if (map.containsKey(location)) {
            return (InputStream)((Supplier)map.get(location)).get();
        }
        throw new FileNotFoundException(location.toString());
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespace, String pathIn, int maxDepth, Predicate<String> filter) {
        TreeMap<ResourceLocation, Supplier<? extends InputStream>> map = type == ResourcePackType.CLIENT_RESOURCES ? this.assets : this.data;
        return map.keySet().stream().filter(rl -> rl.func_110624_b().equals(namespace)).filter(rl -> StringUtils.countMatches((CharSequence)rl.func_110623_a(), (char)'/') < maxDepth).filter(rl -> rl.func_110623_a().startsWith(pathIn)).filter(rl -> {
            String path;
            int lastSlash = (path = rl.func_110623_a()).lastIndexOf(47);
            return filter.test(path.substring(lastSlash < 0 ? 0 : lastSlash, path.length()));
        }).collect(Collectors.toList());
    }

    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        TreeMap<ResourceLocation, Supplier<? extends InputStream>> map = type == ResourcePackType.CLIENT_RESOURCES ? this.assets : this.data;
        return map.containsKey(location);
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        TreeMap<ResourceLocation, Supplier<? extends InputStream>> map = type == ResourcePackType.CLIENT_RESOURCES ? this.assets : this.data;
        return map.keySet().stream().map(rl -> rl.func_110624_b()).collect(Collectors.toSet());
    }

    public <T> T func_195760_a(IMetadataSectionSerializer<T> deserializer) throws IOException {
        return (T)(deserializer == PackMetadataSection.field_198964_a ? deserializer.func_195812_a(this.metadata) : null);
    }

    public String func_195762_a() {
        return this.name;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void close() {
    }
}

