/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.materials;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.materials.Material;
import thelm.jaopca.utils.ApiImpl;

public class MaterialHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TreeMap<String, Material> MATERIALS = new TreeMap();

    private MaterialHandler() {
    }

    public static Map<String, Material> getMaterialMap() {
        return MATERIALS;
    }

    public static Collection<Material> getMaterials() {
        return MATERIALS.values();
    }

    public static Material getMaterial(String name) {
        return MATERIALS.get(name);
    }

    public static boolean containsMaterial(String name) {
        return MATERIALS.containsKey(name);
    }

    public static void findMaterials() {
        Material material;
        MATERIALS.clear();
        TreeSet<Object> allMaterials = new TreeSet<Object>();
        Set<Object> ingots = ConfigHandler.ingot ? MaterialHandler.findItemTagNamesWithPaths("forge:ingots/", "forge:ores/") : new LinkedHashSet();
        ingots.removeAll(ConfigHandler.GEM_OVERRIDES);
        ingots.removeAll(ConfigHandler.CRYSTAL_OVERRIDES);
        ingots.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(ingots);
        Set<Object> gems = ConfigHandler.gem ? MaterialHandler.findItemTagNamesWithPaths("forge:gems/", "forge:ores/") : new LinkedHashSet();
        gems.removeAll(allMaterials);
        gems.removeAll(ConfigHandler.CRYSTAL_OVERRIDES);
        gems.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(gems);
        Set<Object> crystals = ConfigHandler.crystal ? MaterialHandler.findItemTagNamesWithPaths("forge:crystals/", "forge:ores/") : new LinkedHashSet();
        crystals.removeAll(allMaterials);
        crystals.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(crystals);
        Set<Object> dusts = ConfigHandler.dust ? MaterialHandler.findItemTagNamesWithPaths("forge:dusts/", "forge:ores/") : new LinkedHashSet();
        dusts.removeAll(allMaterials);
        allMaterials.addAll(dusts);
        LinkedHashSet ingotsPlain = ConfigHandler.ingotPlain ? MaterialHandler.findItemTagNamesWithPath("forge:ingots/") : new LinkedHashSet();
        ingotsPlain.removeAll(allMaterials);
        ingotsPlain.removeAll(ConfigHandler.GEM_OVERRIDES);
        ingotsPlain.removeAll(ConfigHandler.CRYSTAL_OVERRIDES);
        ingotsPlain.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(ingotsPlain);
        LinkedHashSet gemsPlain = ConfigHandler.gemPlain ? MaterialHandler.findItemTagNamesWithPath("forge:gems/") : new LinkedHashSet();
        gemsPlain.removeAll(allMaterials);
        gemsPlain.removeAll(ConfigHandler.CRYSTAL_OVERRIDES);
        gemsPlain.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(gemsPlain);
        LinkedHashSet crystalsPlain = ConfigHandler.crystalPlain ? MaterialHandler.findItemTagNamesWithPath("forge:crystals/") : new LinkedHashSet();
        crystalsPlain.removeAll(allMaterials);
        crystalsPlain.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(crystalsPlain);
        LinkedHashSet dustsPlain = ConfigHandler.dustPlain ? MaterialHandler.findItemTagNamesWithPath("forge:dusts/") : new LinkedHashSet();
        dustsPlain.removeAll(allMaterials);
        allMaterials.addAll(dustsPlain);
        for (String string : ingots) {
            material = new Material(string, MaterialType.INGOT);
            MATERIALS.put(string, material);
            LOGGER.debug("Added ingot material {}", (Object)string);
        }
        for (String string : gems) {
            material = new Material(string, MaterialType.GEM);
            MATERIALS.put(string, material);
            LOGGER.debug("Added gem material {}", (Object)string);
        }
        for (String string : crystals) {
            material = new Material(string, MaterialType.CRYSTAL);
            MATERIALS.put(string, material);
            LOGGER.debug("Added crystal material {}", (Object)string);
        }
        for (String string : dusts) {
            material = new Material(string, MaterialType.DUST);
            MATERIALS.put(string, material);
            LOGGER.debug("Added dust material {}", (Object)string);
        }
        for (String string : ingotsPlain) {
            material = new Material(string, MaterialType.INGOT_PLAIN);
            MATERIALS.put(string, material);
            LOGGER.debug("Added plain ingot material {}", (Object)string);
        }
        for (String string : gemsPlain) {
            material = new Material(string, MaterialType.GEM_PLAIN);
            MATERIALS.put(string, material);
            LOGGER.debug("Added plain gem material {}", (Object)string);
        }
        for (String string : crystalsPlain) {
            material = new Material(string, MaterialType.CRYSTAL_PLAIN);
            MATERIALS.put(string, material);
            LOGGER.debug("Added plain crystal material {}", (Object)string);
        }
        for (String string : dustsPlain) {
            material = new Material(string, MaterialType.DUST_PLAIN);
            MATERIALS.put(string, material);
            LOGGER.debug("Added plain dust material {}", (Object)string);
        }
        LOGGER.info("Added {} materials", (Object)MATERIALS.size());
    }

    protected static Set<String> findItemTagNamesWithPath(String path) {
        TreeSet<String> ret = new TreeSet<String>();
        Set tags = ApiImpl.INSTANCE.getItemTags().stream().map(ResourceLocation::toString).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String tag : tags) {
            String name;
            if (!tag.startsWith(path) || (name = tag.substring(path.length())).contains("/")) continue;
            ret.add(name);
        }
        return ret;
    }

    protected static Set<String> findItemTagNamesWithPaths(String path1, String path2) {
        TreeSet<String> ret = new TreeSet<String>();
        Set tags = ApiImpl.INSTANCE.getItemTags().stream().map(ResourceLocation::toString).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String tag : tags) {
            String name;
            if (!tag.startsWith(path1) || (name = tag.substring(path1.length())).contains("/") || !tags.contains(path2 + name)) continue;
            ret.add(name);
        }
        return ret;
    }
}

