/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.fluids.PlaceableFluid;
import thelm.jaopca.api.fluids.PlaceableFluidBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;

public class JAOPCAFluidBlock
extends PlaceableFluidBlock
implements IMaterialFormFluidBlock {
    private final IMaterialFormFluid fluid;
    protected final IFluidFormSettings settings;
    protected Optional<Material> blockMaterial = Optional.empty();
    protected Optional<MaterialColor> materialColor = Optional.empty();
    protected OptionalInt lightValue = OptionalInt.empty();
    protected OptionalDouble explosionResistance = OptionalDouble.empty();
    protected OptionalInt flammability = OptionalInt.empty();
    protected OptionalInt fireSpreadSpeed = OptionalInt.empty();
    protected Optional<Boolean> isFireSource = Optional.empty();

    public JAOPCAFluidBlock(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(AbstractBlock.Properties.func_200949_a((Material)settings.getMaterialFunction().apply(fluid.getMaterial()), (MaterialColor)settings.getMaterialColorFunction().apply(fluid.getMaterial())).func_200943_b((float)settings.getBlockHardnessFunction().applyAsDouble(fluid.getMaterial())).func_235838_a_(state -> settings.getLightValueFunction().applyAsInt(fluid.getMaterial())).func_200942_a().func_200944_c().func_222380_e().func_226896_b_(), (PlaceableFluid)fluid.asFluid(), settings.getMaxLevelFunction().applyAsInt(fluid.getMaterial()));
        this.fluid = fluid;
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return this.fluid.getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return this.fluid.getMaterial();
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if (!this.lightValue.isPresent()) {
            this.lightValue = OptionalInt.of(this.settings.getLightValueFunction().applyAsInt(this.getMaterial()));
        }
        return this.lightValue.getAsInt();
    }

    public float func_149638_a() {
        if (!this.explosionResistance.isPresent()) {
            this.explosionResistance = OptionalDouble.of(this.settings.getExplosionResistanceFunction().applyAsDouble(this.getMaterial()));
        }
        return (float)this.explosionResistance.getAsDouble();
    }

    public int getFlammability(BlockState blockState, IBlockReader world, BlockPos pos, Direction face) {
        if (!this.flammability.isPresent()) {
            this.flammability = OptionalInt.of(this.settings.getFireSpreadSpeedFunction().applyAsInt(this.getMaterial()));
        }
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(BlockState blockState, IBlockReader world, BlockPos pos, Direction face) {
        if (!this.fireSpreadSpeed.isPresent()) {
            this.fireSpreadSpeed = OptionalInt.of(this.settings.getFlammabilityFunction().applyAsInt(this.getMaterial()));
        }
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(BlockState blockState, IWorldReader world, BlockPos pos, Direction side) {
        if (!this.isFireSource.isPresent()) {
            this.isFireSource = Optional.of(this.settings.getIsFireSourceFunction().test(this.getMaterial()));
        }
        return this.isFireSource.get();
    }
}

