/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.LootTable;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.modules.ModuleHandler;
import thelm.jaopca.resources.InMemoryResourcePack;

public class DataInjector
extends ReloadListener<Object> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ListMultimap<ResourceLocation, ResourceLocation> BLOCK_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, ResourceLocation> ITEM_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, ResourceLocation> FLUID_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, ResourceLocation> ENTITY_TYPE_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final TreeMap<ResourceLocation, Supplier<? extends IRecipe<?>>> RECIPES_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<LootTable>> LOOT_TABLES_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<Advancement.Builder>> ADVANCEMENTS_INJECT = new TreeMap();
    private static final Gson GSON = LootSerializers.func_237388_c_().create();
    private final RecipeManager recipeManager;

    public static boolean registerBlockTag(ResourceLocation location, ResourceLocation blockLocation) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(blockLocation);
        return BLOCK_TAGS_INJECT.put((Object)location, (Object)blockLocation);
    }

    public static boolean registerItemTag(ResourceLocation location, ResourceLocation itemLocation) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(itemLocation);
        return ITEM_TAGS_INJECT.put((Object)location, (Object)itemLocation);
    }

    public static boolean registerFluidTag(ResourceLocation location, ResourceLocation fluidLocation) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(fluidLocation);
        return FLUID_TAGS_INJECT.put((Object)location, (Object)fluidLocation);
    }

    public static boolean registerEntityTypeTag(ResourceLocation location, ResourceLocation entityTypeLocation) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(entityTypeLocation);
        return ENTITY_TYPE_TAGS_INJECT.put((Object)location, (Object)entityTypeLocation);
    }

    public static boolean registerRecipe(ResourceLocation location, Supplier<? extends IRecipe<?>> recipeSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(recipeSupplier);
        return RECIPES_INJECT.putIfAbsent(location, recipeSupplier) == null;
    }

    public static boolean registerLootTable(ResourceLocation location, Supplier<LootTable> lootTableSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(lootTableSupplier);
        return LOOT_TABLES_INJECT.putIfAbsent(location, lootTableSupplier) == null;
    }

    public static boolean registerAdvancement(ResourceLocation location, Supplier<Advancement.Builder> advancementBuilder) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(advancementBuilder);
        return ADVANCEMENTS_INJECT.putIfAbsent(location, advancementBuilder) == null;
    }

    public static Set<ResourceLocation> getInjectBlockTags() {
        return BLOCK_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectItemTags() {
        return ITEM_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectFluidTags() {
        return FLUID_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectEntityTypeTags() {
        return ENTITY_TYPE_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectRecipes() {
        return RECIPES_INJECT.navigableKeySet();
    }

    public static Set<ResourceLocation> getInjectLootTables() {
        return LOOT_TABLES_INJECT.navigableKeySet();
    }

    public static Set<ResourceLocation> getInjectAdvancements() {
        return ADVANCEMENTS_INJECT.navigableKeySet();
    }

    public static DataInjector getNewInstance(RecipeManager recipeManager) {
        return new DataInjector(recipeManager);
    }

    private DataInjector(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
    }

    protected Object func_212854_a_(IResourceManager resourceManager, IProfiler profiler) {
        return null;
    }

    protected void func_212853_a_(Object splashList, IResourceManager resourceManager, IProfiler profiler) {
        this.injectRecipes(resourceManager);
    }

    public void injectRecipes(IResourceManager resourceManager) {
        ArrayList<IRecipe> recipesToInject = new ArrayList<IRecipe>();
        for (Map.Entry<ResourceLocation, Supplier<IRecipe<?>>> entry2 : RECIPES_INJECT.entrySet()) {
            IRecipe recipe = null;
            try {
                recipe = entry2.getValue().get();
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Recipe with ID {} received invalid arguments: {}", (Object)entry2.getKey(), (Object)e.getMessage());
                continue;
            }
            catch (Throwable e) {
                LOGGER.error("Recipe with ID {} errored", (Object)entry2.getKey(), (Object)e);
                continue;
            }
            if (recipe == null) {
                LOGGER.debug("Recipe with ID {} returned null", (Object)entry2.getKey());
                continue;
            }
            if (!recipe.func_199560_c().equals((Object)entry2.getKey())) {
                LOGGER.warn("Recipe ID {} and registry key {} do not match", (Object)recipe.func_199560_c(), (Object)entry2.getKey());
                continue;
            }
            if (this.recipeManager.func_215378_c().anyMatch(arg_0 -> ((ResourceLocation)entry2.getKey()).equals(arg_0))) {
                LOGGER.warn("Duplicate recipe ignored with ID {}", (Object)entry2.getKey());
                continue;
            }
            recipesToInject.add(recipe);
        }
        Map<IRecipeType, ImmutableMap.Builder> recipesCopy = this.recipeManager.field_199522_d.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ImmutableMap.builder().putAll((Map)entry.getValue())));
        for (IRecipe recipe : recipesToInject) {
            recipesCopy.computeIfAbsent(recipe.func_222127_g(), type -> ImmutableMap.builder()).put((Object)recipe.func_199560_c(), (Object)recipe);
        }
        this.recipeManager.field_199522_d = (Map)recipesCopy.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableMap.Builder)entry.getValue()).build()));
        LOGGER.info("Injected {} recipes, {} recipes total", (Object)recipesToInject.size(), (Object)this.recipeManager.func_215378_c().count());
        ModuleHandler.onRecipeInjectComplete(resourceManager);
    }

    public static class PackFinder
    implements IPackFinder {
        public static final PackFinder INSTANCE = new PackFinder();

        public void func_230230_a_(Consumer<ResourcePackInfo> packList, ResourcePackInfo.IFactory factory) {
            ResourcePackInfo packInfo = ResourcePackInfo.func_195793_a((String)"inmemory:jaopca", (boolean)true, () -> {
                InMemoryResourcePack pack = new InMemoryResourcePack("inmemory:jaopca", true);
                BLOCK_TAGS_INJECT.asMap().forEach((location, locations) -> {
                    ITag.Builder builder = ITag.Builder.func_200047_a();
                    locations.forEach(l -> builder.func_232961_a_(l, "inmemory:jaopca"));
                    pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/blocks/" + location.func_110623_a() + ".json"), (JsonElement)builder.func_232965_c_());
                });
                ITEM_TAGS_INJECT.asMap().forEach((location, locations) -> {
                    ITag.Builder builder = ITag.Builder.func_200047_a();
                    locations.forEach(l -> builder.func_232961_a_(l, "inmemory:jaopca"));
                    pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/items/" + location.func_110623_a() + ".json"), (JsonElement)builder.func_232965_c_());
                });
                FLUID_TAGS_INJECT.asMap().forEach((location, locations) -> {
                    ITag.Builder builder = ITag.Builder.func_200047_a();
                    locations.forEach(l -> builder.func_232961_a_(l, "inmemory:jaopca"));
                    pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/fluids/" + location.func_110623_a() + ".json"), (JsonElement)builder.func_232965_c_());
                });
                ENTITY_TYPE_TAGS_INJECT.asMap().forEach((location, locations) -> {
                    ITag.Builder builder = ITag.Builder.func_200047_a();
                    locations.forEach(l -> builder.func_232961_a_(l, "inmemory:jaopca"));
                    pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/entity_types/" + location.func_110623_a() + ".json"), (JsonElement)builder.func_232965_c_());
                });
                LOOT_TABLES_INJECT.forEach((location, supplier) -> pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "loot_tables/" + location.func_110623_a() + ".json"), GSON.toJsonTree(supplier.get())));
                ADVANCEMENTS_INJECT.forEach((location, supplier) -> pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "advancements/" + location.func_110623_a() + ".json"), (JsonElement)((Advancement.Builder)supplier.get()).func_200273_b()));
                ModuleHandler.onCreateDataPack(pack);
                return pack;
            }, (ResourcePackInfo.IFactory)factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.BOTTOM, (IPackNameDecorator)IPackNameDecorator.field_232626_b_);
            if (packInfo != null) {
                packList.accept(packInfo);
            }
        }
    }
}

