/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.data;

import com.google.common.base.Predicates;
import com.google.common.collect.TreeMultimap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.VanillaPack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.objectweb.asm.Type;
import thelm.jaopca.api.resources.IPackSupplier;
import thelm.jaopca.api.resources.JAOPCAPackSupplier;

public class DataCollector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TAGS_PATH_LENGTH = "tags/".length();
    private static final int RECIPES_PATH_LENGTH = "recipes/".length();
    private static final int LOOT_TABLES_PATH_LENGTH = "loot_tables/".length();
    private static final int ADVANCEMENTS_PATH_LENGTH = "advancements/".length();
    private static final int JSON_EXTENSION_LENGTH = ".json".length();
    private static final Type JAOPCA_PACK_SUPPLIER = Type.getType(JAOPCAPackSupplier.class);
    private static final List<IResourcePack> RESOURCE_PACKS = new ArrayList<IResourcePack>();
    private static final TreeMultimap<String, ResourceLocation> DEFINED_TAGS = TreeMultimap.create();
    private static final TreeSet<ResourceLocation> DEFINED_RECIPES = new TreeSet();
    private static final TreeSet<ResourceLocation> DEFINED_LOOT_TABLES = new TreeSet();
    private static final TreeSet<ResourceLocation> DEFINED_ADVANCEMENTS = new TreeSet();

    private DataCollector() {
    }

    public static void collectData() {
        String path;
        String namespace;
        DEFINED_TAGS.clear();
        DEFINED_RECIPES.clear();
        DEFINED_ADVANCEMENTS.clear();
        if (RESOURCE_PACKS.isEmpty()) {
            RESOURCE_PACKS.add((IResourcePack)new VanillaPack(new String[]{"minecraft"}));
            ModList.get().getModFiles().stream().map(mf -> new ModFileResourcePack(mf.getFile())).forEach(RESOURCE_PACKS::add);
            List annotationData = ModList.get().getAllScanData().stream().flatMap(data -> data.getAnnotations().stream()).filter(data -> JAOPCA_PACK_SUPPLIER.equals((Object)data.getAnnotationType())).collect(Collectors.toList());
            for (ModFileScanData.AnnotationData aData : annotationData) {
                List deps = (List)aData.getAnnotationData().get("modDependencies");
                String className = aData.getClassType().getClassName();
                if (deps != null && deps.stream().filter(Predicates.notNull()).anyMatch(DataCollector::isModVersionNotLoaded)) {
                    LOGGER.info("Pack supplier {} has missing mod dependencies, skipping", (Object)className);
                    continue;
                }
                try {
                    IPackSupplier supplier;
                    Class<?> supplierClass = Class.forName(className);
                    Class<IPackSupplier> supplierInstanceClass = supplierClass.asSubclass(IPackSupplier.class);
                    try {
                        Method method = supplierClass.getMethod("getInstance", new Class[0]);
                        supplier = (IPackSupplier)method.invoke(null, new Object[0]);
                    }
                    catch (NoSuchMethodException | InvocationTargetException e) {
                        supplier = supplierInstanceClass.newInstance();
                    }
                    supplier.addPacks(RESOURCE_PACKS::add);
                    LOGGER.debug("Loaded pack supplier {}", (Object)className);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    LOGGER.fatal("Unable to load pack supplier {}", (Object)className, (Object)e);
                }
            }
        }
        for (ResourceLocation location : DataCollector.getAllDataResourceLocations("tags", name -> name.endsWith(".json"))) {
            namespace = location.func_110624_b();
            path = location.func_110623_a();
            String[] split = (path = path.substring(TAGS_PATH_LENGTH, path.length() - JSON_EXTENSION_LENGTH)).split("/", 2);
            if (split.length == 2) {
                String type = split[0];
                path = split[1];
                DEFINED_TAGS.put((Object)type, (Object)new ResourceLocation(namespace, path));
                continue;
            }
            LOGGER.error("Tag {} in namespace {} has no type", (Object)path, (Object)namespace);
        }
        LOGGER.info("Found {} unique defined tags", (Object)DEFINED_TAGS.size());
        for (ResourceLocation location : DataCollector.getAllDataResourceLocations("recipes", name -> name.endsWith(".json"))) {
            namespace = location.func_110624_b();
            path = location.func_110623_a();
            if (path.equals("recipes/_constants.json") || path.equals("recipes/_factories.json")) continue;
            path = path.substring(RECIPES_PATH_LENGTH, path.length() - JSON_EXTENSION_LENGTH);
            DEFINED_RECIPES.add(new ResourceLocation(namespace, path));
        }
        LOGGER.info("Found {} unique defined recipes", (Object)DEFINED_RECIPES.size());
        for (ResourceLocation location : DataCollector.getAllDataResourceLocations("loot_tables", name -> name.endsWith(".json"))) {
            namespace = location.func_110624_b();
            path = location.func_110623_a();
            path = path.substring(LOOT_TABLES_PATH_LENGTH, path.length() - JSON_EXTENSION_LENGTH);
            DEFINED_LOOT_TABLES.add(new ResourceLocation(namespace, path));
        }
        LOGGER.info("Found {} unique defined loot tables", (Object)DEFINED_LOOT_TABLES.size());
        for (ResourceLocation location : DataCollector.getAllDataResourceLocations("advancements", name -> name.endsWith(".json"))) {
            namespace = location.func_110624_b();
            path = location.func_110623_a();
            path = path.substring(ADVANCEMENTS_PATH_LENGTH, path.length() - JSON_EXTENSION_LENGTH);
            DEFINED_ADVANCEMENTS.add(new ResourceLocation(namespace, path));
        }
        LOGGER.info("Found {} unique defined advancements", (Object)DEFINED_ADVANCEMENTS.size());
        RESOURCE_PACKS.clear();
    }

    public static Set<ResourceLocation> getDefinedTags(String type) {
        return DEFINED_TAGS.get((Object)type);
    }

    public static Set<ResourceLocation> getDefinedRecipes() {
        return DEFINED_RECIPES;
    }

    public static Set<ResourceLocation> getDefinedLootTables() {
        return DEFINED_LOOT_TABLES;
    }

    public static Set<ResourceLocation> getDefinedAdvancements() {
        return DEFINED_ADVANCEMENTS;
    }

    static boolean isModVersionNotLoaded(String dep) {
        VersionRange versionRange;
        ModList modList = ModList.get();
        int separatorIndex = dep.lastIndexOf(64);
        String modId = dep.substring(0, separatorIndex == -1 ? dep.length() : separatorIndex);
        String spec = separatorIndex == -1 ? "0" : dep.substring(separatorIndex + 1, dep.length());
        try {
            versionRange = VersionRange.createFromVersionSpec((String)spec);
        }
        catch (InvalidVersionSpecificationException e) {
            LOGGER.warn("Unable to parse version spec {} for mod id {}", (Object)spec, (Object)modId, (Object)e);
            return true;
        }
        if (modList.isLoaded(modId)) {
            ArtifactVersion version = ((ModContainer)modList.getModContainerById(modId).get()).getModInfo().getVersion();
            if (versionRange.containsVersion(version)) {
                return false;
            }
            LOGGER.warn("Mod {} in version range {} was requested, was {}", (Object)modId, (Object)versionRange, (Object)version);
            return true;
        }
        return true;
    }

    static Collection<ResourceLocation> getAllDataResourceLocations(String pathIn, Predicate<String> filter) {
        TreeSet<ResourceLocation> set = new TreeSet<ResourceLocation>();
        for (IResourcePack resourcePack : RESOURCE_PACKS) {
            for (String namespace : resourcePack.func_195759_a(ResourcePackType.SERVER_DATA)) {
                set.addAll(resourcePack.func_225637_a_(ResourcePackType.SERVER_DATA, namespace, pathIn, Integer.MAX_VALUE, filter));
            }
        }
        return set;
    }
}

