/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.custom.CustomModule;
import thelm.jaopca.materials.Material;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.utils.JsonHelper;

public class MaterialMappedFunctionDeserializer<T>
implements JsonDeserializer<Function<IMaterial, T>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Function<String, T> stringToValue;
    private final Function<T, String> valueToString;

    public MaterialMappedFunctionDeserializer(Function<String, T> stringToValue, Function<T, String> valueToString) {
        this.stringToValue = Objects.requireNonNull(stringToValue);
        this.valueToString = Objects.requireNonNull(valueToString);
    }

    public Function<IMaterial, T> deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonHelper helper = JsonHelper.INSTANCE;
        JsonObject json = helper.getJsonObject(jsonElement, "object");
        String defaultString = helper.getString(json, "default");
        T defaultValue = this.stringToValue.apply(defaultString);
        if (defaultValue == null) {
            LOGGER.warn("Null default value: {}", (Object)defaultString);
        }
        Object2ObjectRBTreeMap map = new Object2ObjectRBTreeMap();
        map.defaultReturnValue(defaultValue);
        if (json.has("materialTypes")) {
            JsonObject materialTypesJson = helper.getJsonObject(json, "materialTypes");
            for (Map.Entry entry : materialTypesJson.entrySet()) {
                String materialTypeString = helper.getString((JsonElement)entry.getValue(), "element");
                T materialTypeValue = this.stringToValue.apply(materialTypeString.toLowerCase(Locale.US));
                if (materialTypeValue == null) {
                    LOGGER.warn("Null value for material type {}: {}", entry.getKey(), (Object)materialTypeString);
                }
                switch ((String)entry.getKey()) {
                    case "ingot": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialMappedFunctionDeserializer.lambda$deserialize$1((Object2ObjectMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "gem": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.GEMS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialMappedFunctionDeserializer.lambda$deserialize$3((Object2ObjectMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "crystal": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.CRYSTALS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialMappedFunctionDeserializer.lambda$deserialize$5((Object2ObjectMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "dust": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialMappedFunctionDeserializer.lambda$deserialize$7((Object2ObjectMap)map, materialTypeValue, arg_0));
                    }
                }
            }
        }
        if (json.has("materials")) {
            JsonObject materialsJson = helper.getJsonObject(json, "materials");
            for (Map.Entry entry : materialsJson.entrySet()) {
                if (!MaterialHandler.containsMaterial((String)entry.getKey())) continue;
                String materialString = helper.getString((JsonElement)entry.getValue(), "element");
                T materialValue = this.stringToValue.apply(materialString);
                if (materialValue == null) {
                    LOGGER.warn("Null value for material {}: {}", entry.getKey(), (Object)materialString);
                }
                map.put((Object)MaterialHandler.getMaterial((String)entry.getKey()), materialValue);
            }
        }
        if (json.has("config") && helper.getBoolean(json, "config")) {
            String path = helper.getString(json, "path");
            String comment = json.has("comment") ? helper.getString(json, "comment") : "";
            CustomModule.instance.addCustomConfigDefiner((arg_0, arg_1) -> this.lambda$deserialize$8(path, (Object2ObjectMap)map, comment, arg_0, arg_1));
        }
        return map;
    }

    private /* synthetic */ void lambda$deserialize$8(String path, Object2ObjectMap map, String comment, IMaterial material, IDynamicSpecConfig config) {
        T value = this.stringToValue.apply(config.getDefinedString(path, "" + this.valueToString.apply(map.get((Object)material)), comment));
        if (value == null) {
            LOGGER.warn("Null config value for material {}", (Object)material.getName());
        }
        map.put((Object)material, value);
    }

    private static /* synthetic */ void lambda$deserialize$7(Object2ObjectMap map, Object materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$5(Object2ObjectMap map, Object materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$3(Object2ObjectMap map, Object materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$1(Object2ObjectMap map, Object materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }
}

