/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.materials.Material;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.utils.JsonHelper;

public class MaterialFunctionDeserializer
implements JsonDeserializer<Function<IMaterial, ?>> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final MaterialFunctionDeserializer INSTANCE = new MaterialFunctionDeserializer();

    private MaterialFunctionDeserializer() {
    }

    public Function<IMaterial, ?> deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonHelper helper = JsonHelper.INSTANCE;
        Type[] typeArguments = ((ParameterizedType)typeOfT).getActualTypeArguments();
        Type parameterizedType = typeArguments[1];
        JsonObject json = helper.getJsonObject(jsonElement, "object");
        Object defaultValue = helper.deserializeType(json, "default", context, parameterizedType);
        if (defaultValue == null) {
            LOGGER.warn("Null default value: {}", (Object)helper.toSimpleString(json.get("default")));
        }
        Object2ObjectRBTreeMap map = new Object2ObjectRBTreeMap();
        map.defaultReturnValue(defaultValue);
        if (json.has("materialTypes")) {
            JsonObject materialTypesJson = helper.getJsonObject(json, "materialTypes");
            for (Map.Entry entry : materialTypesJson.entrySet()) {
                Object materialTypeValue = helper.deserializeType((JsonElement)entry.getValue(), "element", context, parameterizedType);
                if (materialTypeValue == null) {
                    LOGGER.warn("Null value for material type {}: {}", entry.getKey(), (Object)helper.toSimpleString((JsonElement)entry.getValue()));
                }
                switch ((String)entry.getKey()) {
                    case "ingot": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialFunctionDeserializer.lambda$deserialize$1((Object2ObjectMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "gem": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.GEMS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialFunctionDeserializer.lambda$deserialize$3((Object2ObjectMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "crystal": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.CRYSTALS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialFunctionDeserializer.lambda$deserialize$5((Object2ObjectMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "dust": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialFunctionDeserializer.lambda$deserialize$7((Object2ObjectMap)map, materialTypeValue, arg_0));
                    }
                }
            }
        }
        if (json.has("materials")) {
            JsonObject materialsJson = helper.getJsonObject(json, "materials");
            for (Map.Entry entry : materialsJson.entrySet()) {
                if (!MaterialHandler.containsMaterial((String)entry.getKey())) continue;
                Object materialValue = helper.deserializeType((JsonElement)entry.getValue(), "element", context, parameterizedType);
                if (materialValue == null) {
                    LOGGER.warn("Null value for material {}: {}", entry.getKey(), (Object)helper.toSimpleString((JsonElement)entry.getValue()));
                }
                map.put((Object)MaterialHandler.getMaterial((String)entry.getKey()), materialValue);
            }
        }
        return map;
    }

    private static /* synthetic */ void lambda$deserialize$7(Object2ObjectMap map, Object materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$5(Object2ObjectMap map, Object materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$3(Object2ObjectMap map, Object materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$1(Object2ObjectMap map, Object materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }
}

