/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.wtbwmachines.recipes;

import com.wtbw.mods.lib.util.rand.ItemStackChanceMap;
import com.wtbw.mods.machines.recipe.CrushingRecipe;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class CrushingRecipeSupplier
implements Supplier<CrushingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object[] output;
    public final int time;
    public final int energy;

    public CrushingRecipeSupplier(ResourceLocation key, Object input, int inputCount, int time, int energy, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public CrushingRecipe get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStackChanceMap results = new ItemStackChanceMap();
        int i = 0;
        for (int j = 0; i < this.output.length && j < 6; ++j) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, 1)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            results.add(chance.floatValue(), count.intValue(), (Object)stack);
        }
        return new CrushingRecipe(this.key, ing, this.inputCount, results, this.time, this.energy);
    }
}

