/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.voluminousenergy.recipes;

import com.veteam.voluminousenergy.recipe.CompressorRecipe;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class CompressingRecipeSupplier
implements Supplier<CompressorRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final int time;

    public CompressingRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, int time) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
    }

    @Override
    public CompressorRecipe get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        try {
            CompressorRecipe ret = new CompressorRecipe(this.key);
            ret.ingredient = ing;
            ret.ingredientCount = this.inputCount;
            ret.result = stack;
            Field processTimeField = CompressorRecipe.class.getDeclaredField("processTime");
            Field outputAmountField = CompressorRecipe.class.getDeclaredField("outputAmount");
            processTimeField.setAccessible(true);
            outputAmountField.setAccessible(true);
            processTimeField.setInt(ret, this.time);
            outputAmountField.setInt(ret, this.outputCount);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

