/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.voluminousenergy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.voluminousenergy.VoluminousEnergyHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"voluminousenergy"})
public class VoluminousEnergyCompatModule
implements IModule {
    private static final Set<String> TO_PLATE_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "carbon", "solarium", "titanium"));
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "voluminousenergy_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have compressor recipes added."), configToPlateBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        VoluminousEnergyHelper helper = VoluminousEnergyHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            MaterialType type = material.getType();
            String name = material.getName();
            if (!ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) || TO_PLATE_BLACKLIST.contains(name) || configToPlateBlacklist.contains(name)) continue;
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ResourceLocation plateLocation = miscHelper.getTagLocation("plates", material.getName());
            if (!((JAOPCAApi)api).getItemTags().contains(plateLocation)) continue;
            helper.registerCompressingRecipe(new ResourceLocation("jaopca", "voluminousenergy.material_to_plate." + material.getName()), materialLocation, 1, plateLocation, 1, 200);
        }
    }
}

