/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thermalexpansion;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.thermalexpansion.ThermalExpansionHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"thermal_expansion@[1.4.0,)"})
public class ThermalExpansionNonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("apatite", "cinnabar", "coal", "diamond", "emerald", "lapis", "niter", "quartz", "redstone", "ruby", "sapphire", "sulfur"));
    private static final Set<String> PULVERIZER_BLACKLIST = new TreeSet<String>();
    private static final Set<String> SMELTER_BLACKLIST = new TreeSet<String>();

    @Override
    public String getName() {
        return "thermal_expansion_non_ingot";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)1, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        ThermalExpansionHelper helper = ThermalExpansionHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Item richSlag = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:rich_slag"));
        for (IMaterial material : moduleData.getMaterials()) {
            float smelterChance;
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation extraDustLocation = miscHelper.getTagLocation("dusts", material.getExtra(1).getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ResourceLocation extraMaterialLocation = miscHelper.getTagLocation(material.getExtra(1).getType().getFormName(), material.getExtra(1).getName());
            float pulverizerChance = material.getType() != MaterialType.DUST ? 2.5f : 6.5f;
            float f = smelterChance = material.getType() != MaterialType.DUST ? 1.5f : 3.5f;
            if (material.hasExtra(1)) {
                if (!PULVERIZER_BLACKLIST.contains(material.getName())) {
                    helper.registerPulverizerRecipe(new ResourceLocation("jaopca", "thermal_expansion.ore_to_material_pulverizer." + material.getName()), oreLocation, 1, new Object[]{materialLocation, Float.valueOf(pulverizerChance), extraDustLocation, Float.valueOf(0.1f), Blocks.field_150351_n, Float.valueOf(0.2f)}, 4000, 0.2f);
                }
                if (SMELTER_BLACKLIST.contains(material.getName())) continue;
                helper.registerSmelterRecipe(new ResourceLocation("jaopca", "thermal_expansion.ore_to_material_smelter." + material.getName()), new Object[]{oreLocation}, new Object[]{materialLocation, Float.valueOf(smelterChance), extraMaterialLocation, Float.valueOf(0.2f), richSlag, Float.valueOf(0.15f)}, 3200, 0.2f);
                continue;
            }
            helper.registerPulverizerRecipe(new ResourceLocation("jaopca", "thermal_expansion.ore_to_material_pulverizer." + material.getName()), oreLocation, 1, new Object[]{materialLocation, Float.valueOf(pulverizerChance), Blocks.field_150351_n, Float.valueOf(0.2f)}, 4000, 0.2f);
            helper.registerSmelterRecipe(new ResourceLocation("jaopca", "thermal_expansion.ore_to_material_smelter." + material.getName()), new Object[]{oreLocation}, new Object[]{materialLocation, Float.valueOf(smelterChance), richSlag, Float.valueOf(0.15f)}, 3200, 0.2f);
        }
    }

    static {
        if (ModList.get().isLoaded("druidcraft")) {
            Collections.addAll(PULVERIZER_BLACKLIST, "amber", "fiery_glass", "moonstone", "rockroot");
        }
        if (ModList.get().isLoaded("mekanism")) {
            Collections.addAll(PULVERIZER_BLACKLIST, "fluorite");
        }
        if (ModList.get().isLoaded("rftools")) {
            Collections.addAll(PULVERIZER_BLACKLIST, "dimensional_shard");
        }
    }
}

