/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.ISlurryProvider;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.inputs.chemical.SlurryStackIngredient;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.compat.mekanism.MekanismDataInjector;
import thelm.jaopca.compat.mekanism.recipes.CombiningRecipeSupplier;
import thelm.jaopca.compat.mekanism.recipes.CrushingRecipeSupplier;
import thelm.jaopca.compat.mekanism.recipes.CrystallizingRecipeSupplier;
import thelm.jaopca.compat.mekanism.recipes.DissolutionRecipeSupplier;
import thelm.jaopca.compat.mekanism.recipes.EnrichingRecipeSupplier;
import thelm.jaopca.compat.mekanism.recipes.InjectingRecipeSupplier;
import thelm.jaopca.compat.mekanism.recipes.PurifyingRecipeSupplier;
import thelm.jaopca.compat.mekanism.recipes.WashingRecipeSupplier;
import thelm.jaopca.tags.EmptyNamedTag;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class MekanismHelper {
    public static final MekanismHelper INSTANCE = new MekanismHelper();

    private MekanismHelper() {
    }

    public Set<ResourceLocation> getSlurryTags() {
        return ImmutableSortedSet.copyOf((Collection)Sets.union(ApiImpl.INSTANCE.getTags("slurries"), MekanismDataInjector.getInjectSlurryTags()));
    }

    public FluidStackIngredient getFluidStackIngredient(Object obj, int amount) {
        if (obj instanceof Supplier) {
            return this.getFluidStackIngredient(((Supplier)obj).get(), amount);
        }
        if (obj instanceof FluidStackIngredient) {
            return (FluidStackIngredient)obj;
        }
        if (obj instanceof String) {
            return FluidStackIngredient.from(this.getFluidTag(new ResourceLocation((String)obj)), (int)amount);
        }
        if (obj instanceof ResourceLocation) {
            return FluidStackIngredient.from(this.getFluidTag((ResourceLocation)obj), (int)amount);
        }
        if (obj instanceof ITag) {
            return FluidStackIngredient.from((ITag)((ITag)obj), (int)amount);
        }
        if (obj instanceof FluidStack) {
            return FluidStackIngredient.from((FluidStack)((FluidStack)obj));
        }
        if (obj instanceof FluidStack[]) {
            return FluidStackIngredient.createMulti((FluidStackIngredient[])((FluidStackIngredient[])Arrays.stream((FluidStack[])obj).map(FluidStackIngredient::from).toArray(FluidStackIngredient[]::new)));
        }
        if (obj instanceof Fluid) {
            return FluidStackIngredient.from((Fluid)((Fluid)obj), (int)amount);
        }
        if (obj instanceof Fluid[]) {
            return FluidStackIngredient.createMulti((FluidStackIngredient[])((FluidStackIngredient[])Arrays.stream((Fluid[])obj).map(g -> FluidStackIngredient.from((Fluid)g, (int)amount)).toArray(FluidStackIngredient[]::new)));
        }
        if (obj instanceof JsonElement) {
            return FluidStackIngredient.deserialize((JsonElement)((JsonElement)obj));
        }
        return FluidStackIngredient.createMulti((FluidStackIngredient[])new FluidStackIngredient[0]);
    }

    public GasStackIngredient getGasStackIngredient(Object obj, int amount) {
        if (obj instanceof Supplier) {
            return this.getGasStackIngredient(((Supplier)obj).get(), amount);
        }
        if (obj instanceof GasStackIngredient) {
            return (GasStackIngredient)obj;
        }
        if (obj instanceof String) {
            return GasStackIngredient.from(this.getGasTag(new ResourceLocation((String)obj)), (long)amount);
        }
        if (obj instanceof ResourceLocation) {
            return GasStackIngredient.from(this.getGasTag((ResourceLocation)obj), (long)amount);
        }
        if (obj instanceof ITag) {
            return GasStackIngredient.from((ITag)((ITag)obj), (long)amount);
        }
        if (obj instanceof GasStack) {
            return GasStackIngredient.from((GasStack)((GasStack)obj));
        }
        if (obj instanceof GasStack[]) {
            return GasStackIngredient.createMulti((GasStackIngredient[])((GasStackIngredient[])Arrays.stream((GasStack[])obj).map(GasStackIngredient::from).toArray(GasStackIngredient[]::new)));
        }
        if (obj instanceof IGasProvider) {
            return GasStackIngredient.from((IGasProvider)((IGasProvider)obj), (long)amount);
        }
        if (obj instanceof IGasProvider[]) {
            return GasStackIngredient.createMulti((GasStackIngredient[])((GasStackIngredient[])Arrays.stream((IGasProvider[])obj).map(g -> GasStackIngredient.from((IGasProvider)g, (long)amount)).toArray(GasStackIngredient[]::new)));
        }
        if (obj instanceof JsonElement) {
            return GasStackIngredient.deserialize((JsonElement)((JsonElement)obj));
        }
        return GasStackIngredient.createMulti((GasStackIngredient[])new GasStackIngredient[0]);
    }

    public SlurryStackIngredient getSlurryStackIngredient(Object obj, int amount) {
        if (obj instanceof Supplier) {
            return this.getSlurryStackIngredient(((Supplier)obj).get(), amount);
        }
        if (obj instanceof SlurryStackIngredient) {
            return (SlurryStackIngredient)obj;
        }
        if (obj instanceof String) {
            return SlurryStackIngredient.from(this.getSlurryTag(new ResourceLocation((String)obj)), (long)amount);
        }
        if (obj instanceof ResourceLocation) {
            return SlurryStackIngredient.from(this.getSlurryTag((ResourceLocation)obj), (long)amount);
        }
        if (obj instanceof ITag) {
            return SlurryStackIngredient.from((ITag)((ITag)obj), (long)amount);
        }
        if (obj instanceof SlurryStack) {
            return SlurryStackIngredient.from((SlurryStack)((SlurryStack)obj));
        }
        if (obj instanceof SlurryStack[]) {
            return SlurryStackIngredient.createMulti((SlurryStackIngredient[])((SlurryStackIngredient[])Arrays.stream((SlurryStack[])obj).map(SlurryStackIngredient::from).toArray(SlurryStackIngredient[]::new)));
        }
        if (obj instanceof ISlurryProvider) {
            return SlurryStackIngredient.from((ISlurryProvider)((ISlurryProvider)obj), (long)amount);
        }
        if (obj instanceof ISlurryProvider[]) {
            return SlurryStackIngredient.createMulti((SlurryStackIngredient[])((SlurryStackIngredient[])Arrays.stream((ISlurryProvider[])obj).map(g -> SlurryStackIngredient.from((ISlurryProvider)g, (long)amount)).toArray(SlurryStackIngredient[]::new)));
        }
        if (obj instanceof JsonElement) {
            return SlurryStackIngredient.deserialize((JsonElement)((JsonElement)obj));
        }
        return SlurryStackIngredient.createMulti((SlurryStackIngredient[])new SlurryStackIngredient[0]);
    }

    public GasStack getGasStack(Object obj, int amount) {
        if (obj instanceof Supplier) {
            return this.getGasStack(((Supplier)obj).get(), amount);
        }
        if (obj instanceof GasStack) {
            return (GasStack)obj;
        }
        if (obj instanceof IGasProvider) {
            return new GasStack((IGasProvider)obj, (long)amount);
        }
        if (obj instanceof String) {
            return this.getPreferredGasStack(this.getGasTag(new ResourceLocation((String)obj)).func_230236_b_(), amount);
        }
        if (obj instanceof ResourceLocation) {
            return this.getPreferredGasStack(this.getGasTag((ResourceLocation)obj).func_230236_b_(), amount);
        }
        if (obj instanceof ITag) {
            return this.getPreferredGasStack(((ITag)obj).func_230236_b_(), amount);
        }
        return GasStack.EMPTY;
    }

    public SlurryStack getSlurryStack(Object obj, int amount) {
        if (obj instanceof Supplier) {
            return this.getSlurryStack(((Supplier)obj).get(), amount);
        }
        if (obj instanceof SlurryStack) {
            return (SlurryStack)obj;
        }
        if (obj instanceof ISlurryProvider) {
            return new SlurryStack((ISlurryProvider)obj, (long)amount);
        }
        if (obj instanceof String) {
            return this.getPreferredSlurryStack(this.getSlurryTag(new ResourceLocation((String)obj)).func_230236_b_(), amount);
        }
        if (obj instanceof ResourceLocation) {
            return this.getPreferredSlurryStack(this.getSlurryTag((ResourceLocation)obj).func_230236_b_(), amount);
        }
        if (obj instanceof ITag) {
            return this.getPreferredSlurryStack(((ITag)obj).func_230236_b_(), amount);
        }
        return SlurryStack.EMPTY;
    }

    public boolean registerCrushingRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CrushingRecipeSupplier(key, input, inputCount, output, outputCount));
    }

    public boolean registerEnrichingRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new EnrichingRecipeSupplier(key, input, inputCount, output, outputCount));
    }

    public boolean registerCombiningRecipe(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CombiningRecipeSupplier(key, input, inputCount, secondInput, secondInputCount, output, outputCount));
    }

    public boolean registerWashingRecipe(ResourceLocation key, Object fluidInput, int fluidInputCount, Object gasInput, int gasInputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new WashingRecipeSupplier(key, fluidInput, fluidInputCount, gasInput, gasInputCount, output, outputCount));
    }

    public boolean registerCrystallizingRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CrystallizingRecipeSupplier(key, input, inputCount, output, outputCount));
    }

    public boolean registerDissolutionRecipe(ResourceLocation key, Object itemInput, int itemInputCount, Object gasInput, int gasInputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new DissolutionRecipeSupplier(key, itemInput, itemInputCount, gasInput, gasInputCount, output, outputCount));
    }

    public boolean registerPurifyingRecipe(ResourceLocation key, Object itemInput, int itemInputCount, Object gasInput, int gasInputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PurifyingRecipeSupplier(key, itemInput, itemInputCount, gasInput, gasInputCount, output, outputCount));
    }

    public boolean registerInjectingRecipe(ResourceLocation key, Object itemInput, int itemInputCount, Object gasInput, int gasInputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new InjectingRecipeSupplier(key, itemInput, itemInputCount, gasInput, gasInputCount, output, outputCount));
    }

    public ITag<Gas> getGasTag(ResourceLocation location) {
        ITag tag = ChemicalTags.GAS.getCollection().func_199910_a(location);
        return tag != null ? tag : Tag.func_241284_a_();
    }

    public GasStack getPreferredGasStack(Collection<Gas> collection, int amount) {
        return new GasStack((IGasProvider)MiscHelper.INSTANCE.getPreferredEntry(collection).orElse(MekanismAPI.EMPTY_GAS), (long)amount);
    }

    public ITag<Slurry> getSlurryTag(ResourceLocation location) {
        ITag tag = ChemicalTags.SLURRY.getCollection().func_199910_a(location);
        return tag != null ? tag : new EmptyNamedTag(location);
    }

    public SlurryStack getPreferredSlurryStack(Collection<Slurry> collection, int amount) {
        return new SlurryStack((ISlurryProvider)MiscHelper.INSTANCE.getPreferredEntry(collection).orElse(MekanismAPI.EMPTY_SLURRY), (long)amount);
    }

    public ITag<Fluid> getFluidTag(ResourceLocation location) {
        ITag tag = TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(location);
        return tag != null ? tag : new EmptyNamedTag(location);
    }

    public ITag<Item> getItemTag(ResourceLocation location) {
        ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(location);
        return tag != null ? tag : new EmptyNamedTag(location);
    }
}

