/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.kubejs.utils;

import com.google.common.collect.TreeBasedTable;
import dev.latvian.kubejs.fluid.EmptyFluidStackJS;
import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.TagIngredientJS;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import thelm.jaopca.api.blocks.IBlockProvider;
import thelm.jaopca.api.fluids.IFluidProvider;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materialforms.IMaterialFormInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.kubejs.utils.Form;
import thelm.jaopca.compat.kubejs.utils.Material;
import thelm.jaopca.utils.MiscHelper;

public class MaterialForm {
    private static final TreeBasedTable<IForm, IMaterial, MaterialForm> MATERIAL_FORM_WRAPPERS = TreeBasedTable.create();
    private final IMaterialFormInfo info;

    public static MaterialForm getMaterialFormWrapper(IForm form, IMaterial material) {
        MaterialForm materialForm = (MaterialForm)MATERIAL_FORM_WRAPPERS.get((Object)form, (Object)material);
        if (materialForm == null) {
            IMaterialFormInfo info = form.getType().getMaterialFormInfo(form, material);
            materialForm = new MaterialForm(info);
        }
        return materialForm;
    }

    private MaterialForm(IMaterialFormInfo info) {
        this.info = info;
    }

    public IMaterialFormInfo getInternal() {
        return this.info;
    }

    public Form getForm() {
        return Form.getFormWrapper(this.info.getMaterialForm().getForm());
    }

    public Material getMaterial() {
        return Material.getMaterialWrapper(this.info.getMaterialForm().getMaterial());
    }

    public TagIngredientJS asTag() {
        return TagIngredientJS.createTag((String)MiscHelper.INSTANCE.getTagLocation(this.info.getMaterialForm().getForm().getSecondaryName(), this.info.getMaterialForm().getMaterial().getName(), this.info.getMaterialForm().getForm().getTagSeparator()).toString());
    }

    public ItemStackJS asItemStack(int count) {
        return ItemStackJS.of((Object)this.info);
    }

    public ItemStackJS asItemStack() {
        return this.asItemStack(1);
    }

    public FluidStackJS asFluidStack(int amount) {
        if (!(this.info instanceof IFluidProvider)) {
            return EmptyFluidStackJS.INSTANCE;
        }
        return FluidStackJS.of((Object)((IFluidProvider)((Object)this.info)).asFluid(), (int)amount, null);
    }

    public Block asBlock() {
        if (!(this.info instanceof IBlockProvider)) {
            return null;
        }
        return ((IBlockProvider)((Object)this.info)).asBlock();
    }

    public BlockState asBlockState() {
        if (!(this.info instanceof IBlockProvider)) {
            return null;
        }
        return ((IBlockProvider)((Object)this.info)).asBlock().func_176223_P();
    }
}

