/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.kubejs.utils;

import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.TagIngredientJS;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import me.shedaniel.architectury.hooks.forge.FluidStackHooksForge;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.kubejs.utils.Form;
import thelm.jaopca.compat.kubejs.utils.MaterialForm;
import thelm.jaopca.utils.MiscHelper;

public class Material {
    private static final TreeMap<IMaterial, Material> MATERIAL_WRAPPERS = new TreeMap();
    private final IMaterial material;

    public static Material getMaterialWrapper(IMaterial material) {
        return MATERIAL_WRAPPERS.computeIfAbsent(material, Material::new);
    }

    private Material(IMaterial material) {
        this.material = material;
    }

    public IMaterial getInternal() {
        return this.material;
    }

    public String getName() {
        return this.material.getName();
    }

    public String getType() {
        return this.material.getType().getName();
    }

    public List<String> getAlternativeNames() {
        return this.material.getAlternativeNames().stream().collect(Collectors.toList());
    }

    public Material getExtra(int index) {
        return new Material(this.material.getExtra(index));
    }

    public boolean hasExtra(int index) {
        return this.material.hasExtra(index);
    }

    public TagIngredientJS getTag(String prefix) {
        return this.getTag(prefix, "/");
    }

    public TagIngredientJS getTag(String prefix, String tagSeperator) {
        return TagIngredientJS.createTag((String)MiscHelper.INSTANCE.getTagLocation(prefix, this.material.getName(), tagSeperator).toString());
    }

    public ItemStackJS getItemStack(String prefix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        ItemStack stack = helper.getItemStack(helper.getTagLocation(prefix, this.material.getName()), count);
        return ItemStackJS.of((Object)stack);
    }

    public ItemStackJS getItemStack(String prefix) {
        return this.getItemStack(prefix, 1);
    }

    public FluidStackJS getFluidStack(String prefix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        FluidStack stack = helper.getFluidStack(helper.getTagLocation(prefix, this.material.getName()), count);
        return FluidStackJS.of((Object)FluidStackHooksForge.fromForge((FluidStack)stack));
    }

    public MaterialForm getMaterialForm(Form form) {
        if (!form.containsMaterial(this)) {
            return null;
        }
        return MaterialForm.getMaterialFormWrapper(form.getInternal(), this.material);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Material)) {
            return false;
        }
        Material other = (Material)obj;
        return this.material == other.material;
    }

    public int hashCode() {
        return this.material.hashCode() + 7;
    }
}

