/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.indreb.recipes;

import com.google.common.base.Strings;
import com.maciej916.indreb.common.receipe.RecipeChanceResult;
import com.maciej916.indreb.common.receipe.impl.CrushingRecipe;
import com.maciej916.indreb.common.util.Cache;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class CrushingRecipeSupplier
implements Supplier<CrushingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final float secondChance;
    public final int time;
    public final int power;
    public final float experience;

    public CrushingRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, int time, int power, float experience) {
        this(key, "", input, inputCount, output, outputCount, ItemStack.field_190927_a, 0, 0.0f, time, power, experience);
    }

    public CrushingRecipeSupplier(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, int time, int power, float experience) {
        this(key, group, input, inputCount, output, outputCount, ItemStack.field_190927_a, 0, 0.0f, time, power, experience);
    }

    public CrushingRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondCount, float secondChance, int time, int power, float experience) {
        this(key, "", input, inputCount, output, outputCount, secondOutput, secondCount, secondChance, time, power, experience);
    }

    public CrushingRecipeSupplier(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, Object secondOutput, int secondOutputCount, float secondChance, int time, int power, float experience) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondChance = secondChance;
        this.time = time;
        this.power = power;
        this.experience = experience;
    }

    @Override
    public CrushingRecipe get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        if (this.secondChance > 0.0f && secondStack.func_190926_b()) {
            LOGGER.warn("Empty non-zero chance second output in recipe {}: {}", (Object)this.key, this.secondOutput);
        }
        try {
            CrushingRecipe ret = new CrushingRecipe(this.key);
            Field ingredientField = CrushingRecipe.class.getDeclaredField("ingredient");
            Field ingredientCountField = CrushingRecipe.class.getDeclaredField("ingredientCount");
            Field ingredientListField = CrushingRecipe.class.getDeclaredField("ingredientList");
            Field resultField = CrushingRecipe.class.getDeclaredField("result");
            Field bonusResultField = CrushingRecipe.class.getDeclaredField("bonusResult");
            Field durationField = CrushingRecipe.class.getDeclaredField("duration");
            Field powerCostField = CrushingRecipe.class.getDeclaredField("powerCost");
            Field experienceField = CrushingRecipe.class.getDeclaredField("experience");
            ingredientField.setAccessible(true);
            ingredientCountField.setAccessible(true);
            ingredientListField.setAccessible(true);
            resultField.setAccessible(true);
            bonusResultField.setAccessible(true);
            durationField.setAccessible(true);
            powerCostField.setAccessible(true);
            experienceField.setAccessible(true);
            ingredientField.set(ret, ing);
            ingredientCountField.setInt(ret, this.inputCount);
            ingredientListField.set(ret, Cache.create(() -> NonNullList.func_193580_a((Object)ing, (Object[])new Ingredient[0])));
            resultField.set(ret, stack);
            ((RecipeChanceResult)bonusResultField.get(ret)).addChanceResult(secondStack, this.secondChance);
            durationField.setInt(ret, this.time);
            powerCostField.setInt(ret, this.power);
            experienceField.setFloat(ret, this.experience);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

