/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.immersiveengineering.recipes;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class CrusherRecipeSupplier
implements Supplier<CrusherRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] output;
    public final int energy;

    public CrusherRecipeSupplier(ResourceLocation key, Object input, Object[] output, int energy) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.energy = energy;
    }

    @Override
    public CrusherRecipe get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack result = null;
        ArrayList<StackWithChance> secondary = new ArrayList<StackWithChance>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            if (result == null) {
                result = stack;
                continue;
            }
            secondary.add(new StackWithChance(stack, chance.floatValue()));
        }
        if (result == null) {
            LOGGER.warn("No output in recipe {}", (Object)this.key);
            result = ItemStack.field_190927_a;
        }
        CrusherRecipe recipe = new CrusherRecipe(this.key, result, ing, this.energy);
        for (StackWithChance stack : secondary) {
            recipe.addToSecondaryOutput(stack);
        }
        return recipe;
    }
}

