/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.futurepack.recipes;

import futurepack.api.ItemPredicateBase;
import futurepack.common.recipes.centrifuge.ZentrifugeRecipe;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.compat.futurepack.FuturepackHelper;
import thelm.jaopca.utils.MiscHelper;

public class ZentrifugeRecipeSupplier
implements Supplier<ZentrifugeRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final Object input;
    public final int inputCount;
    public final Object[] output;
    public final int support;
    public final int time;

    public ZentrifugeRecipeSupplier(Object input, int inputCount, int support, int time, Object ... output) {
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.support = support;
        this.time = time;
    }

    @Override
    public ZentrifugeRecipe get() {
        ItemPredicateBase ing = FuturepackHelper.INSTANCE.getItemPredicateBase(this.input, this.inputCount);
        if (ing.collectAcceptedItems(new ArrayList()).isEmpty()) {
            throw new IllegalArgumentException("Empty ingredient in zentrifuge recipe: " + this.input);
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in zentrifuge recipe: {}", out);
            }
            results.add(stack);
        }
        ZentrifugeRecipe ret = new ZentrifugeRecipe(ing, results.toArray(new ItemStack[results.size()]), this.support);
        ret.setTime(this.time);
        return ret;
    }
}

