/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.ftbic.recipes;

import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.StackWithChance;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public abstract class MachineRecipeSupplier
implements Supplier<MachineRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] itemInput;
    public final Object[] fluidInput;
    public final Object[] itemOutput;
    public final Object[] fluidOutput;
    public final double time;

    public MachineRecipeSupplier(ResourceLocation key, Object[] itemInput, Object[] fluidInput, Object[] itemOutput, Object[] fluidOutput, double time) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.fluidInput = fluidInput;
        this.itemOutput = itemOutput;
        this.fluidOutput = fluidOutput;
        this.time = time;
    }

    public abstract Supplier<MachineRecipeSerializer> serializerSupplier();

    @Override
    public MachineRecipe get() {
        ItemStack stack;
        ArrayList<IngredientWithCount> itemInputs = new ArrayList<IngredientWithCount>();
        int i = 0;
        while (i < this.itemInput.length) {
            Ingredient ing;
            Object in = this.itemInput[i];
            Integer count = 1;
            if (++i < this.itemInput.length && this.itemInput[i] instanceof Integer) {
                count = (Integer)this.itemInput[i];
                ++i;
            }
            if ((ing = MiscHelper.INSTANCE.getIngredient(in)).func_203189_d()) {
                LOGGER.warn("Empty ingredient in recipe {}: {}", (Object)this.key, in);
            }
            itemInputs.add(new IngredientWithCount(ing, count.intValue()));
        }
        ArrayList<FluidStack> fluidInputs = new ArrayList<FluidStack>();
        i = 0;
        while (i < this.fluidInput.length) {
            FluidStack fs;
            Object in = this.fluidInput[i];
            Integer amount = 1;
            if (++i < this.fluidInput.length && this.fluidInput[i] instanceof Integer) {
                amount = (Integer)this.fluidInput[i];
                ++i;
            }
            if ((fs = MiscHelper.INSTANCE.getFluidStack(in, amount)).isEmpty()) {
                LOGGER.warn("Empty input in recipe {}: {}", (Object)this.key, in);
            }
            fluidInputs.add(fs);
        }
        ArrayList<StackWithChance> itemOutputs = new ArrayList<StackWithChance>();
        i = 0;
        while (i < this.itemOutput.length) {
            Object out = this.itemOutput[i];
            Integer count = 1;
            if (++i < this.itemOutput.length && this.itemOutput[i] instanceof Integer) {
                count = (Integer)this.itemOutput[i];
                ++i;
            }
            Double chance = 1.0;
            if (i < this.itemOutput.length && this.itemOutput[i] instanceof Double) {
                chance = (Double)this.itemOutput[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            itemOutputs.add(new StackWithChance(stack, chance.doubleValue()));
        }
        ArrayList<ItemStack> fluidOutputs = new ArrayList<ItemStack>();
        i = 0;
        while (i < this.fluidOutput.length) {
            Object out = this.fluidOutput[i];
            Integer amount = 1;
            if (++i < this.fluidOutput.length && this.fluidOutput[i] instanceof Integer) {
                amount = (Integer)this.fluidOutput[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getFluidStack(out, amount)).isEmpty()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            fluidOutputs.add(stack);
        }
        MachineRecipe rec = new MachineRecipe(this.serializerSupplier().get(), this.key);
        rec.inputItems.addAll(itemInputs);
        rec.inputFluids.addAll(fluidInputs);
        rec.outputItems.addAll(itemOutputs);
        rec.outputFluids.addAll(fluidOutputs);
        rec.processingTime = this.time;
        return rec;
    }
}

