/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.ftbic;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.ftbic.FTBICHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"ftbic"})
public class FTBICCompatModule
implements IModule {
    private static boolean addToFTBICMaterials = false;
    private static Set<String> configToDustBlacklist = new TreeSet<String>();
    private static Set<String> configToRodBlacklist = new TreeSet<String>();
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configToGearBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "ftbic_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        config.getDefinedBoolean("recipes.addToFTBICMaterials", addToFTBICMaterials, "Should materials be directly added to FTBIC's material list to generate recipes instead of having JAOPCA do so.");
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have macerator recipes added."), configToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have roller to plate recipes added."), configToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toGearMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have roller to gear recipes added."), configToGearBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toRodMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have extruder to rod recipes added."), configToRodBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        FTBICHelper helper = FTBICHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<String> generalBlacklist = helper.getBlacklist();
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation gearLocation;
            ResourceLocation materialLocation;
            MaterialType type = material.getType();
            String name = material.getName();
            boolean addToMaterials = false;
            if (!(ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)type)) || generalBlacklist.contains(name) || configToDustBlacklist.contains(name))) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(dustLocation)) {
                    if (!addToFTBICMaterials) {
                        helper.registerMaceratingRecipe(new ResourceLocation("jaopca", "ftbic.material_to_dust." + material.getName()), materialLocation, 1, new Object[]{dustLocation, 1, 1.0}, 1.0);
                    } else {
                        addToMaterials = true;
                    }
                }
            }
            if (!(ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)type)) || generalBlacklist.contains(name) || configToPlateBlacklist.contains(name))) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation plateLocation = miscHelper.getTagLocation("plates", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(plateLocation)) {
                    if (!addToFTBICMaterials) {
                        helper.registerRollingRecipe(new ResourceLocation("jaopca", "ftbic.material_to_plate." + material.getName()), materialLocation, 1, plateLocation, 2, 1.0);
                    } else {
                        addToMaterials = true;
                    }
                }
            }
            if (ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) && !generalBlacklist.contains(name) && !configToGearBlacklist.contains(name)) {
                ResourceLocation plateLocation = miscHelper.getTagLocation("plates", material.getName());
                gearLocation = miscHelper.getTagLocation("gears", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(plateLocation) && ((JAOPCAApi)api).getItemTags().contains(gearLocation)) {
                    if (!addToFTBICMaterials) {
                        helper.registerRollingRecipe(new ResourceLocation("jaopca", "ftbic.plate_to_gear." + material.getName()), plateLocation, 4, gearLocation, 1, 1.0);
                    } else {
                        addToMaterials = true;
                    }
                }
            }
            if ((ArrayUtils.contains((Object[])MaterialType.GEMS, (Object)((Object)type)) || ArrayUtils.contains((Object[])MaterialType.CRYSTALS, (Object)((Object)type))) && !generalBlacklist.contains(name) && !configToGearBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                gearLocation = miscHelper.getTagLocation("gears", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(gearLocation)) {
                    if (!addToFTBICMaterials) {
                        helper.registerRollingRecipe(new ResourceLocation("jaopca", "ftbic.material_to_gear." + material.getName()), materialLocation, 2, gearLocation, 1, 1.0);
                    } else {
                        addToMaterials = true;
                    }
                }
            }
            if (!(ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)type)) || generalBlacklist.contains(name) || configToRodBlacklist.contains(name))) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation rodLocation = miscHelper.getTagLocation("rods", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(rodLocation)) {
                    if (!addToFTBICMaterials) {
                        helper.registerExtrudingRecipe(new ResourceLocation("jaopca", "ftbic.material_to_rod." + material.getName()), materialLocation, 1, rodLocation, 2, 1.0);
                    } else {
                        addToMaterials = true;
                    }
                }
            }
            if (!addToMaterials) continue;
            helper.addMaterial(name);
        }
    }
}

