/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics.recipes;

import electrodynamics.common.recipe.categories.o2o.specificmachines.LatheRecipe;
import electrodynamics.common.recipe.recipeutils.CountableIngredient;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.compat.electrodynamics.ElectrodynamicsHelper;
import thelm.jaopca.utils.MiscHelper;

public class LatheRecipeSupplier
implements Supplier<LatheRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;

    public LatheRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public LatheRecipe get() {
        CountableIngredient ing = ElectrodynamicsHelper.INSTANCE.getCountableIngredient(this.input, this.inputCount);
        if (ing.fetchCountedStacks().isEmpty()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        return new LatheRecipe(this.key, ing, stack);
    }
}

