/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics.recipes;

import electrodynamics.common.recipe.categories.fluid2item.specificmachines.ChemicalCrystalizerRecipe;
import electrodynamics.common.recipe.recipeutils.FluidIngredient;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.compat.electrodynamics.ElectrodynamicsHelper;
import thelm.jaopca.utils.MiscHelper;

public class ChemicalCrystallizerRecipeSupplier
implements Supplier<ChemicalCrystalizerRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputAmount;
    public final Object output;
    public final int outputCount;

    public ChemicalCrystallizerRecipeSupplier(ResourceLocation key, Object input, int inputAmount, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public ChemicalCrystalizerRecipe get() {
        FluidIngredient ing = ElectrodynamicsHelper.INSTANCE.getFluidIngredient(this.input, this.inputAmount);
        if (ing.getMatchingFluidStacks().isEmpty()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        return new ChemicalCrystalizerRecipe(this.key, ing, stack);
    }
}

