/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.create;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.create.CreateHelper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"create"})
public class CreateModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "copper", "gold", "iron", "lead", "nickel", "osmium", "platinum", "quicksilver", "silver", "tin", "uranium", "zinc"));
    private Map<IMaterial, IDynamicSpecConfig> configs;
    private final IForm crushedOreForm = ApiImpl.INSTANCE.newForm(this, "create_crushed_ores", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT).setSecondaryName("create:crushed_ores").setDefaultMaterialBlacklist(BLACKLIST);

    @Override
    public String getName() {
        return "create";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"nuggets");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.crushedOreForm.toRequest());
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        CreateHelper helper = CreateHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        for (IMaterial material : this.crushedOreForm.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            IItemInfo crushedOreInfo = itemFormType.getMaterialFormInfo(this.crushedOreForm, material);
            IDynamicSpecConfig config = this.configs.get(material);
            String configByproduct = config.getDefinedString("create.byproduct", "minecraft:cobblestone", s -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(s)), "The byproduct material to output in Create's crushing.");
            Item byproduct = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(configByproduct));
            helper.registerMillingRecipe(new ResourceLocation("jaopca", "create.ore_to_crushed_milling." + material.getName()), oreLocation, 350, crushedOreInfo, 1);
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "create.ore_to_crushed_crushing." + material.getName()), oreLocation, 350, crushedOreInfo, 1, crushedOreInfo, 2, Float.valueOf(0.3f), byproduct, 1, Float.valueOf(0.125f));
        }
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation crushedOreLocation = miscHelper.getTagLocation("create:crushed_ores", material.getName());
            ResourceLocation nuggetLocation = miscHelper.getTagLocation("nuggets", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ((JAOPCAApi)api).registerSmeltingRecipe(new ResourceLocation("jaopca", "create.crushed_to_ingot_smelting." + material.getName()), crushedOreLocation, materialLocation, 1, 0.1f, 200);
            ((JAOPCAApi)api).registerBlastingRecipe(new ResourceLocation("jaopca", "create.crushed_to_ingot_blasting." + material.getName()), crushedOreLocation, materialLocation, 1, 0.1f, 50);
            helper.registerSplashingRecipe(new ResourceLocation("jaopca", "create.crushed_to_nugget." + material.getName()), crushedOreLocation, nuggetLocation, 10, nuggetLocation, 5, Float.valueOf(0.5f));
        }
    }
}

