/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStack;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManager;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerItem;
import com.google.common.collect.TreeBasedTable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;
import thelm.jaopca.api.blocks.IBlockProvider;
import thelm.jaopca.api.fluids.IFluidProvider;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materialforms.IMaterialFormInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.crafttweaker.Form;
import thelm.jaopca.compat.crafttweaker.Material;
import thelm.jaopca.utils.MiscHelper;

@ZenRegister
@ZenCodeType.Name(value="mods.jaopca.MaterialForm")
public class MaterialForm {
    private static final TreeBasedTable<IForm, IMaterial, MaterialForm> MATERIAL_FORM_WRAPPERS = TreeBasedTable.create();
    private final IMaterialFormInfo info;

    public static MaterialForm getMaterialFormWrapper(IForm form, IMaterial material) {
        MaterialForm materialForm = (MaterialForm)MATERIAL_FORM_WRAPPERS.get((Object)form, (Object)material);
        if (materialForm == null) {
            IMaterialFormInfo info = form.getType().getMaterialFormInfo(form, material);
            materialForm = new MaterialForm(info);
        }
        return materialForm;
    }

    private MaterialForm(IMaterialFormInfo info) {
        this.info = info;
    }

    public IMaterialFormInfo getInternal() {
        return this.info;
    }

    @ZenCodeType.Getter(value="form")
    public Form getForm() {
        return Form.getFormWrapper(this.info.getMaterialForm().getForm());
    }

    @ZenCodeType.Getter(value="material")
    public Material getMaterial() {
        return Material.getMaterialWrapper(this.info.getMaterialForm().getMaterial());
    }

    @ZenCodeType.Method
    public MCTag asTag() {
        return this.asTag((TagManager)TagManagerItem.INSTANCE);
    }

    @ZenCodeType.Method
    public MCTag asTag(TagManager manager) {
        return new MCTag(MiscHelper.INSTANCE.getTagLocation(this.info.getMaterialForm().getForm().getSecondaryName(), this.info.getMaterialForm().getMaterial().getName(), this.info.getMaterialForm().getForm().getTagSeparator()), manager);
    }

    @ZenCodeType.Method
    public IItemStack asItemStack(int count) {
        if (!(this.info instanceof IItemProvider)) {
            return null;
        }
        return new MCItemStack(new ItemStack((IItemProvider)this.info, count));
    }

    @ZenCodeType.Method
    public IItemStack asItemStack() {
        return this.asItemStack(1);
    }

    @ZenCodeType.Method
    public IFluidStack asFluidStack(int amount) {
        if (!(this.info instanceof IFluidProvider)) {
            return null;
        }
        return new MCFluidStack(new FluidStack(((IFluidProvider)((Object)this.info)).asFluid(), amount));
    }

    @ZenCodeType.Method
    public Block asBlock() {
        if (!(this.info instanceof IBlockProvider)) {
            return null;
        }
        return ((IBlockProvider)((Object)this.info)).asBlock();
    }

    @ZenCodeType.Method
    public BlockState asBlockState() {
        if (!(this.info instanceof IBlockProvider)) {
            return null;
        }
        return ((IBlockProvider)((Object)this.info)).asBlock().func_176223_P();
    }
}

