/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.advancedrocketry.recipes;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;
import zmaster587.libVulpes.recipe.RecipeMachineFactory;
import zmaster587.libVulpes.recipe.RecipesMachine;

public abstract class MachineRecipeSupplier
implements Supplier<RecipesMachine.Recipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] itemInput;
    public final Object[] fluidInput;
    public final Object[] itemOutput;
    public final Object[] fluidOutput;
    public final int time;
    public final int energy;
    public final int maxOutput;

    public MachineRecipeSupplier(ResourceLocation key, Object[] itemInput, Object[] fluidInput, Object[] itemOutput, Object[] fluidOutput, int time, int energy, int maxOutput) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.fluidInput = fluidInput;
        this.itemOutput = itemOutput;
        this.fluidOutput = fluidOutput;
        this.time = time;
        this.energy = energy;
        this.maxOutput = maxOutput;
    }

    public abstract RecipeMachineFactory factoryInstance();

    @Override
    public RecipesMachine.Recipe get() {
        LinkedList itemInputs = new LinkedList();
        int i = 0;
        while (i < this.itemInput.length) {
            Ingredient ing;
            Object in = this.itemInput[i];
            Integer count = 1;
            if (++i < this.itemInput.length && this.itemInput[i] instanceof Integer) {
                count = (Integer)this.itemInput[i];
                ++i;
            }
            if ((ing = MiscHelper.INSTANCE.getIngredient(in)).func_203189_d()) {
                LOGGER.warn("Empty ingredient in recipe {}: {}", (Object)this.key, in);
            }
            LinkedList<ItemStack> ingStacks = new LinkedList<ItemStack>();
            for (ItemStack is : ing.func_193365_a()) {
                ItemStack copy = is.func_77946_l();
                copy.func_190920_e(count.intValue());
                ingStacks.add(copy);
            }
            itemInputs.add(ingStacks);
        }
        LinkedList<FluidStack> fluidInputs = new LinkedList<FluidStack>();
        i = 0;
        while (i < this.fluidInput.length) {
            FluidStack fs;
            Object in = this.fluidInput[i];
            Integer amount = 1;
            if (++i < this.fluidInput.length && this.fluidInput[i] instanceof Integer) {
                amount = (Integer)this.fluidInput[i];
                ++i;
            }
            if ((fs = MiscHelper.INSTANCE.getFluidStack(in, amount)).isEmpty()) {
                LOGGER.warn("Empty input in recipe {}: {}", (Object)this.key, in);
            }
            fluidInputs.add(fs);
        }
        LinkedList<RecipesMachine.ChanceItemStack> itemOutputs = new LinkedList<RecipesMachine.ChanceItemStack>();
        i = 0;
        while (i < this.itemOutput.length) {
            ItemStack stack;
            Object out = this.itemOutput[i];
            Integer count = 1;
            if (++i < this.itemOutput.length && this.itemOutput[i] instanceof Integer) {
                count = (Integer)this.itemOutput[i];
                ++i;
            }
            Float chance = Float.valueOf(0.0f);
            if (i < this.itemOutput.length && this.itemOutput[i] instanceof Float) {
                chance = (Float)this.itemOutput[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            itemOutputs.add(new RecipesMachine.ChanceItemStack(stack, chance.floatValue()));
        }
        LinkedList<RecipesMachine.ChanceFluidStack> fluidOutputs = new LinkedList<RecipesMachine.ChanceFluidStack>();
        i = 0;
        while (i < this.fluidOutput.length) {
            FluidStack stack;
            Object out = this.fluidOutput[i];
            Integer amount = 1;
            if (++i < this.fluidOutput.length && this.fluidOutput[i] instanceof Integer) {
                amount = (Integer)this.fluidOutput[i];
                ++i;
            }
            Float chance = Float.valueOf(0.0f);
            if (i < this.fluidOutput.length && this.fluidOutput[i] instanceof Float) {
                chance = (Float)this.fluidOutput[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getFluidStack(out, amount)).isEmpty()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            fluidOutputs.add(new RecipesMachine.ChanceFluidStack(stack, chance.floatValue()));
        }
        RecipesMachine.Recipe rec = new RecipesMachine.Recipe((IRecipeSerializer)this.factoryInstance(), this.key, itemOutputs, itemInputs, fluidOutputs, fluidInputs, this.time, this.energy, Collections.emptyMap());
        rec.setMaxOutputSize(this.maxOutput);
        RecipesMachine.getInstance().recipeList.computeIfAbsent(this.factoryInstance().getMachine(), c -> new LinkedList()).add(rec);
        return rec;
    }
}

