/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ToolType;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABlock
extends Block
implements IMaterialFormBlock {
    private final IForm form;
    private final IMaterial material;
    protected final IBlockFormSettings settings;
    protected boolean blocksMovement;
    protected Optional<SoundType> field_149762_H = Optional.empty();
    protected OptionalInt lightValue = OptionalInt.empty();
    protected OptionalDouble explosionResistance = OptionalDouble.empty();
    protected OptionalDouble field_149765_K = OptionalDouble.empty();
    protected VoxelShape shape;
    protected VoxelShape raytraceShape;
    protected Optional<ToolType> harvestTool = Optional.empty();
    protected OptionalInt harvestLevel = OptionalInt.empty();
    protected OptionalInt flammability = OptionalInt.empty();
    protected OptionalInt fireSpreadSpeed = OptionalInt.empty();
    protected Optional<Boolean> isFireSource = Optional.empty();

    public JAOPCABlock(IForm form, IMaterial material, IBlockFormSettings settings) {
        super(AbstractBlock.Properties.func_200949_a((Material)settings.getMaterialFunction().apply(material), (MaterialColor)settings.getMaterialColorFunction().apply(material)).func_200943_b((float)settings.getBlockHardnessFunction().applyAsDouble(material)).func_235838_a_(state -> settings.getLightValueFunction().applyAsInt(material)).func_226896_b_());
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.blocksMovement = settings.getBlocksMovement();
        this.shape = settings.getShape();
        this.raytraceShape = settings.getRaytraceShape();
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public SoundType func_220072_p(BlockState blockState) {
        if (!this.field_149762_H.isPresent()) {
            this.field_149762_H = Optional.of(this.settings.getSoundTypeFunction().apply(this.material));
        }
        return this.field_149762_H.get();
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if (!this.lightValue.isPresent()) {
            this.lightValue = OptionalInt.of(this.settings.getLightValueFunction().applyAsInt(this.material));
        }
        return this.lightValue.getAsInt();
    }

    public float func_149638_a() {
        if (!this.explosionResistance.isPresent()) {
            this.explosionResistance = OptionalDouble.of(this.settings.getExplosionResistanceFunction().applyAsDouble(this.material));
        }
        return (float)this.explosionResistance.getAsDouble();
    }

    public float getSlipperiness(BlockState blockState, IWorldReader world, BlockPos pos, Entity entity) {
        if (!this.field_149765_K.isPresent()) {
            this.field_149765_K = OptionalDouble.of(this.settings.getSlipperinessFunction().applyAsDouble(this.material));
        }
        return (float)this.field_149765_K.getAsDouble();
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.shape;
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.blocksMovement ? blockState.func_196954_c(world, pos) : VoxelShapes.func_197880_a();
    }

    public VoxelShape func_199600_g(BlockState blockState, IBlockReader world, BlockPos pos) {
        return this.raytraceShape;
    }

    public ToolType getHarvestTool(BlockState blockState) {
        if (!this.harvestTool.isPresent()) {
            this.harvestTool = Optional.ofNullable(this.settings.getHarvestToolFunction().apply(this.material));
        }
        return this.harvestTool.orElse(null);
    }

    public int getHarvestLevel(BlockState blockState) {
        if (!this.harvestLevel.isPresent()) {
            this.harvestLevel = OptionalInt.of(this.settings.getHarvestLevelFunction().applyAsInt(this.material));
        }
        return this.harvestLevel.getAsInt();
    }

    public int getFlammability(BlockState blockState, IBlockReader world, BlockPos pos, Direction face) {
        if (!this.flammability.isPresent()) {
            this.flammability = OptionalInt.of(this.settings.getFireSpreadSpeedFunction().applyAsInt(this.material));
        }
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(BlockState blockState, IBlockReader world, BlockPos pos, Direction face) {
        if (!this.fireSpreadSpeed.isPresent()) {
            this.fireSpreadSpeed = OptionalInt.of(this.settings.getFlammabilityFunction().applyAsInt(this.material));
        }
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(BlockState blockState, IWorldReader world, BlockPos pos, Direction side) {
        if (!this.isFireSource.isPresent()) {
            this.isFireSource = Optional.of(this.settings.getIsFireSourceFunction().test(this.material));
        }
        return this.isFireSource.get();
    }

    public IFormattableTextComponent func_235333_g_() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("block.jaopca." + this.form.getName(), this.material, this.func_149739_a());
    }
}

