/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.fluids;

import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.fluids.PlaceableFluidBlock;

public abstract class PlaceableFluid
extends Fluid {
    public static final float EIGHT_NINTHS = 0.8888889f;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>> CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>(200){

            protected void rehash(int newN) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    protected final StateContainer<Fluid, FluidState> field_207202_e;
    private final Map<FluidState, VoxelShape> shapeMap = new IdentityHashMap<FluidState, VoxelShape>();
    protected final int maxLevel;
    protected final IntegerProperty levelProperty;

    public PlaceableFluid(int maxLevel) {
        this.maxLevel = maxLevel;
        this.levelProperty = IntegerProperty.func_177719_a((String)"level", (int)1, (int)(maxLevel + 1));
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_207184_a((StateContainer.Builder<Fluid, FluidState>)builder);
        this.field_207202_e = builder.func_235882_a_(Fluid::func_207188_f, FluidState::new);
        this.func_207183_f((FluidState)((FluidState)this.field_207202_e.func_177621_b()).func_206870_a((Property)this.levelProperty, (Comparable)Integer.valueOf(maxLevel)));
    }

    public IntegerProperty getLevelProperty() {
        return this.levelProperty;
    }

    protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
        if (this.levelProperty != null) {
            builder.func_206894_a(new Property[]{this.levelProperty});
        }
    }

    public StateContainer<Fluid, FluidState> func_207182_e() {
        return this.field_207202_e;
    }

    protected abstract boolean canSourcesMultiply();

    protected boolean func_215665_a(FluidState fluidState, IBlockReader world, BlockPos pos, Fluid fluid, Direction face) {
        return face == Direction.DOWN && !this.func_207187_a(fluid);
    }

    protected abstract int getLevelDecreasePerBlock(IWorldReader var1);

    protected BlockState func_204527_a(FluidState fluidState) {
        PlaceableFluidBlock block = this.getFluidBlock();
        IntegerProperty blockLevelProperty = block.getLevelProperty();
        int fluidLevel = (Integer)fluidState.func_177229_b((Property)this.levelProperty);
        int blockLevel = fluidLevel > this.maxLevel ? this.maxLevel : this.maxLevel - fluidLevel;
        return (BlockState)block.func_176223_P().func_206870_a((Property)blockLevelProperty, (Comparable)Integer.valueOf(blockLevel));
    }

    protected abstract PlaceableFluidBlock getFluidBlock();

    protected Vector3d func_215663_a(IBlockReader world, BlockPos pos, FluidState state) {
        double x = 0.0;
        double y = 0.0;
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (Direction offset : Direction.Plane.HORIZONTAL) {
            mutablePos.func_189533_g((Vector3i)pos).func_189536_c(offset);
            FluidState offsetState = world.func_204610_c((BlockPos)mutablePos);
            if (!this.isSameOrEmpty(offsetState)) continue;
            float offsetHeight = offsetState.func_223408_f();
            float heightDiff = 0.0f;
            if (offsetHeight == 0.0f) {
                BlockPos posDown;
                FluidState belowState;
                if (!world.func_180495_p((BlockPos)mutablePos).func_185904_a().func_76230_c() && this.isSameOrEmpty(belowState = world.func_204610_c(posDown = mutablePos.func_177977_b())) && (offsetHeight = belowState.func_223408_f()) > 0.0f) {
                    heightDiff = state.func_223408_f() - (offsetHeight - 0.8888889f);
                }
            } else if (offsetHeight > 0.0f) {
                heightDiff = state.func_223408_f() - offsetHeight;
            }
            if (heightDiff == 0.0f) continue;
            x += (double)((float)offset.func_82601_c() * heightDiff);
            y += (double)((float)offset.func_82599_e() * heightDiff);
        }
        Vector3d flow = new Vector3d(x, 0.0, y);
        if ((Integer)state.func_177229_b((Property)this.levelProperty) == 0) {
            for (Direction offset : Direction.Plane.HORIZONTAL) {
                mutablePos.func_189533_g((Vector3i)pos).func_189536_c(offset);
                if (!this.causesDownwardCurrent(world, (BlockPos)mutablePos, offset) && !this.causesDownwardCurrent(world, mutablePos.func_177984_a(), offset)) continue;
                flow = flow.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
                break;
            }
        }
        return flow.func_72432_b();
    }

    private boolean isSameOrEmpty(FluidState otherState) {
        return otherState.func_206888_e() || otherState.func_206886_c().func_207187_a((Fluid)this);
    }

    protected boolean causesDownwardCurrent(IBlockReader world, BlockPos pos, Direction face) {
        BlockState blockState = world.func_180495_p(pos);
        FluidState fluidState = world.func_204610_c(pos);
        return !fluidState.func_206886_c().func_207187_a((Fluid)this) && (face == Direction.UP || blockState.func_185904_a() != Material.field_151588_w && blockState.func_224755_d(world, pos, face));
    }

    protected void flowAround(IWorld world, BlockPos pos, FluidState fluidState) {
        if (!fluidState.func_206888_e()) {
            BlockState blockState = world.func_180495_p(pos);
            BlockPos downPos = pos.func_177977_b();
            BlockState downBlockState = world.func_180495_p(downPos);
            FluidState newFluidState = this.calculateCorrectState((IWorldReader)world, downPos, downBlockState);
            if (this.canFlow((IBlockReader)world, pos, blockState, Direction.DOWN, downPos, downBlockState, world.func_204610_c(downPos), newFluidState.func_206886_c())) {
                this.flowInto(world, downPos, downBlockState, Direction.DOWN, newFluidState);
                if (this.getAdjacentSourceCount((IWorldReader)world, pos) >= 3) {
                    this.flowAdjacent(world, pos, fluidState, blockState);
                }
            } else if (fluidState.func_206889_d() || !this.canFlowDown((IBlockReader)world, newFluidState.func_206886_c(), pos, blockState, downPos, downBlockState)) {
                this.flowAdjacent(world, pos, fluidState, blockState);
            }
        }
    }

    protected void flowAdjacent(IWorld world, BlockPos pos, FluidState fluidState, BlockState blockState) {
        int i = fluidState.func_206882_g() - this.getLevelDecreasePerBlock((IWorldReader)world);
        if (i > 0) {
            Map<Direction, FluidState> map = this.calculateAdjacentStates((IWorldReader)world, pos, blockState);
            for (Map.Entry<Direction, FluidState> entry : map.entrySet()) {
                BlockState offsetBlockState;
                Direction direction = entry.getKey();
                FluidState offsetFluidState = entry.getValue();
                BlockPos offsetPos = pos.func_177972_a(direction);
                if (!this.canFlow((IBlockReader)world, pos, blockState, direction, offsetPos, offsetBlockState = world.func_180495_p(offsetPos), world.func_204610_c(offsetPos), offsetFluidState.func_206886_c())) continue;
                this.flowInto(world, offsetPos, offsetBlockState, direction, offsetFluidState);
            }
        }
    }

    protected FluidState calculateCorrectState(IWorldReader world, BlockPos pos, BlockState blockState) {
        BlockPos upPos;
        BlockState upBlockState;
        FluidState upFluidState;
        int i = 0;
        int j = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(direction);
            BlockState offsetBlockState = world.func_180495_p(offsetPos);
            FluidState offsetFluidState = offsetBlockState.func_204520_s();
            if (!offsetFluidState.func_206886_c().func_207187_a((Fluid)this) || !this.doShapesFillSquare(direction, (IBlockReader)world, pos, blockState, offsetPos, offsetBlockState)) continue;
            if (offsetFluidState.func_206889_d()) {
                ++j;
            }
            i = Math.max(i, offsetFluidState.func_206882_g());
        }
        if (this.canSourcesMultiply() && j >= 2) {
            BlockState blockstate1 = world.func_180495_p(pos.func_177977_b());
            FluidState FluidState1 = blockstate1.func_204520_s();
            if (blockstate1.func_185904_a().func_76220_a() || this.isSameSource(FluidState1)) {
                return (FluidState)this.func_207188_f().func_206870_a((Property)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel));
            }
        }
        if (!(upFluidState = (upBlockState = world.func_180495_p(upPos = pos.func_177984_a())).func_204520_s()).func_206888_e() && upFluidState.func_206886_c().func_207187_a((Fluid)this) && this.doShapesFillSquare(Direction.UP, (IBlockReader)world, pos, blockState, upPos, upBlockState)) {
            return (FluidState)this.func_207188_f().func_206870_a((Property)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel + 1));
        }
        int k = i - this.getLevelDecreasePerBlock(world);
        if (k <= 0) {
            return Fluids.field_204541_a.func_207188_f();
        }
        return (FluidState)this.func_207188_f().func_206870_a((Property)this.levelProperty, (Comparable)Integer.valueOf(k));
    }

    protected boolean doShapesFillSquare(Direction direction, IBlockReader world, BlockPos fromPos, BlockState fromBlockState, BlockPos toPos, BlockState toBlockState) {
        VoxelShape toShape;
        VoxelShape fromShape;
        boolean flag;
        Block.RenderSideCacheKey cacheKey;
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> cache = !fromBlockState.func_177230_c().func_208619_r() && !toBlockState.func_177230_c().func_208619_r() ? CACHE.get() : null;
        if (cache != null) {
            cacheKey = new Block.RenderSideCacheKey(fromBlockState, toBlockState, direction);
            byte b0 = cache.getAndMoveToFirst((Object)cacheKey);
            if (b0 != 127) {
                return b0 != 0;
            }
        } else {
            cacheKey = null;
        }
        boolean bl = flag = !VoxelShapes.func_204642_b((VoxelShape)(fromShape = fromBlockState.func_196952_d(world, fromPos)), (VoxelShape)(toShape = toBlockState.func_196952_d(world, toPos)), (Direction)direction);
        if (cache != null) {
            if (cache.size() == 200) {
                cache.removeLastByte();
            }
            cache.putAndMoveToFirst((Object)cacheKey, (byte)(flag ? 1 : 0));
        }
        return flag;
    }

    protected void flowInto(IWorld world, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        if (blockState.func_177230_c() instanceof ILiquidContainer) {
            ((ILiquidContainer)blockState.func_177230_c()).func_204509_a(world, pos, blockState, fluidState);
        } else {
            if (!blockState.isAir((IBlockReader)world, pos)) {
                this.beforeReplacingBlock(world, pos, blockState);
            }
            world.func_180501_a(pos, fluidState.func_206883_i(), 3);
        }
    }

    protected void beforeReplacingBlock(IWorld world, BlockPos pos, BlockState blockState) {
        TileEntity tile = blockState.hasTileEntity() ? world.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)blockState, (IWorld)world, (BlockPos)pos, (TileEntity)tile);
    }

    protected static short getPosKey(BlockPos pos, BlockPos otherPos) {
        int dx = otherPos.func_177958_n() - pos.func_177958_n();
        int dz = otherPos.func_177952_p() - pos.func_177952_p();
        return (short)((dx + 128 & 0xFF) << 8 | dz + 128 & 0xFF);
    }

    protected Map<Direction, FluidState> calculateAdjacentStates(IWorldReader world, BlockPos pos, BlockState blockState) {
        int i = 1000;
        EnumMap<Direction, FluidState> map = new EnumMap<Direction, FluidState>(Direction.class);
        Short2ObjectOpenHashMap stateMap = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap canFlowDownMap = new Short2BooleanOpenHashMap();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(direction);
            short key = PlaceableFluid.getPosKey(pos, offsetPos);
            Pair offsetState = (Pair)stateMap.computeIfAbsent(key, k -> {
                BlockState offsetBlockState = world.func_180495_p(offsetPos);
                return Pair.of((Object)offsetBlockState, (Object)offsetBlockState.func_204520_s());
            });
            BlockState offsetBlockState = (BlockState)offsetState.getLeft();
            FluidState offsetFluidState = (FluidState)offsetState.getRight();
            FluidState newOffsetFluidState = this.calculateCorrectState(world, offsetPos, offsetBlockState);
            if (!this.canFlowSource((IBlockReader)world, newOffsetFluidState.func_206886_c(), pos, blockState, direction, offsetPos, offsetBlockState, offsetFluidState)) continue;
            boolean flag = canFlowDownMap.computeIfAbsent(key, k -> {
                BlockPos offsetDownPos = offsetPos.func_177977_b();
                BlockState offsetDownState = world.func_180495_p(offsetDownPos);
                return this.canFlowDown((IBlockReader)world, this, offsetPos, offsetBlockState, offsetDownPos, offsetDownState);
            });
            int j = 0;
            if (!flag) {
                j = this.getFlowDistance(world, offsetPos, 1, direction.func_176734_d(), offsetBlockState, pos, (Short2ObjectMap<Pair<BlockState, FluidState>>)stateMap, (Short2BooleanMap)canFlowDownMap);
            }
            if (j < i) {
                map.clear();
            }
            if (j > i) continue;
            map.put(direction, newOffsetFluidState);
            i = j;
        }
        return map;
    }

    protected int getFlowDistance(IWorldReader world, BlockPos pos, int distance, Direction fromDirection, BlockState blockState, BlockPos startPos, Short2ObjectMap<Pair<BlockState, FluidState>> stateMap, Short2BooleanMap canFlowDownMap) {
        int i = 1000;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int j;
            FluidState offsetFluidstate;
            short key;
            Pair pair;
            BlockState offsetBlockState;
            BlockPos offsetPos;
            if (direction == fromDirection || !this.canFlowSource((IBlockReader)world, this, pos, blockState, direction, offsetPos = pos.func_177972_a(direction), offsetBlockState = (BlockState)(pair = (Pair)stateMap.computeIfAbsent(key = PlaceableFluid.getPosKey(startPos, offsetPos), k -> {
                BlockState offsetBlockState = world.func_180495_p(offsetPos);
                return Pair.of((Object)offsetBlockState, (Object)offsetBlockState.func_204520_s());
            })).getLeft(), offsetFluidstate = (FluidState)pair.getRight())) continue;
            boolean flag = canFlowDownMap.computeIfAbsent(key, k -> {
                BlockPos offsetDownPos = offsetPos.func_177977_b();
                BlockState offsetDownState = world.func_180495_p(offsetDownPos);
                return this.canFlowDown((IBlockReader)world, this, offsetPos, offsetBlockState, offsetDownPos, offsetDownState);
            });
            if (flag) {
                return distance;
            }
            if (distance >= this.getSlopeFindDistance(world) || (j = this.getFlowDistance(world, offsetPos, distance + 1, direction.func_176734_d(), offsetBlockState, startPos, stateMap, canFlowDownMap)) >= i) continue;
            i = j;
        }
        return i;
    }

    protected boolean isSameSource(FluidState fluidState) {
        return fluidState.func_206886_c().func_207187_a((Fluid)this) && fluidState.func_206889_d();
    }

    protected int getSlopeFindDistance(IWorldReader world) {
        return PlaceableFluid.ceilDiv(PlaceableFluid.ceilDiv(this.maxLevel, this.getLevelDecreasePerBlock(world)), 2);
    }

    protected int getAdjacentSourceCount(IWorldReader world, BlockPos pos) {
        int count = 0;
        for (Direction offset : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(offset);
            FluidState offsetState = world.func_204610_c(offsetPos);
            if (!this.isSameSource(offsetState)) continue;
            ++count;
        }
        return count;
    }

    protected boolean canFlowIntoBlock(IBlockReader world, BlockPos pos, BlockState blockState, Fluid fluid) {
        Block block = blockState.func_177230_c();
        if (block instanceof ILiquidContainer) {
            return ((ILiquidContainer)block).func_204510_a(world, pos, blockState, fluid);
        }
        if (block instanceof DoorBlock || block.func_203417_a((ITag)BlockTags.field_219753_V) || block == Blocks.field_150468_ap || block == Blocks.field_196608_cF || block == Blocks.field_203203_C) {
            return false;
        }
        Material blockMaterial = blockState.func_185904_a();
        return blockMaterial != Material.field_151567_E && blockMaterial != Material.field_189963_J && blockMaterial != Material.field_203243_f && blockMaterial != Material.field_204868_h && !blockMaterial.func_76230_c();
    }

    protected boolean canFlow(IBlockReader world, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState, Fluid fluid) {
        return toFluidState.func_215677_a(world, toPos, fluid, direction) && this.doShapesFillSquare(direction, world, fromPos, fromBlockState, toPos, toBlockState) && this.canFlowIntoBlock(world, toPos, toBlockState, fluid);
    }

    protected boolean canFlowSource(IBlockReader world, Fluid fluid, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState) {
        return !this.isSameSource(toFluidState) && this.doShapesFillSquare(direction, world, fromPos, fromBlockState, toPos, toBlockState) && this.canFlowIntoBlock(world, toPos, toBlockState, fluid);
    }

    protected boolean canFlowDown(IBlockReader world, Fluid fluid, BlockPos fromPos, BlockState fromBlockState, BlockPos downPos, BlockState downState) {
        return this.doShapesFillSquare(Direction.DOWN, world, fromPos, fromBlockState, downPos, downState) && (downState.func_204520_s().func_206886_c().func_207187_a((Fluid)this) || this.canFlowIntoBlock(world, downPos, downState, fluid));
    }

    protected int getDelay(World world, BlockPos pos, FluidState fluidState, FluidState newFluidState) {
        return this.func_205569_a((IWorldReader)world);
    }

    public void func_207191_a(World world, BlockPos pos, FluidState fluidState) {
        if (!fluidState.func_206889_d()) {
            FluidState newFluidState = this.calculateCorrectState((IWorldReader)world, pos, world.func_180495_p(pos));
            int delay = this.getDelay(world, pos, fluidState, newFluidState);
            if (newFluidState.func_206888_e()) {
                fluidState = newFluidState;
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            } else if (!newFluidState.equals(fluidState)) {
                fluidState = newFluidState;
                BlockState blockState = fluidState.func_206883_i();
                world.func_180501_a(pos, blockState, 2);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), delay);
                world.func_195593_d(pos, blockState.func_177230_c());
            }
        }
        this.flowAround((IWorld)world, pos, fluidState);
    }

    protected int getBlockLevelFromState(FluidState fluidState) {
        int level = (Integer)fluidState.func_177229_b((Property)this.levelProperty);
        if (level > this.maxLevel) {
            return this.maxLevel;
        }
        return this.maxLevel - Math.min(fluidState.func_206882_g(), this.maxLevel);
    }

    protected static boolean isFluidAboveSame(FluidState fluidState, IBlockReader world, BlockPos pos) {
        return fluidState.func_206886_c().func_207187_a(world.func_204610_c(pos.func_177984_a()).func_206886_c());
    }

    public float func_215662_a(FluidState fluidState, IBlockReader world, BlockPos pos) {
        return fluidState.func_223408_f();
    }

    public float func_223407_a(FluidState fluidState) {
        return 0.9f * (float)fluidState.func_206882_g() / (float)this.maxLevel;
    }

    public boolean func_207193_c(FluidState fluidState) {
        return (Integer)fluidState.func_177229_b((Property)this.levelProperty) == this.maxLevel;
    }

    public int func_207192_d(FluidState fluidState) {
        return Math.min(this.maxLevel, (Integer)fluidState.func_177229_b((Property)this.levelProperty));
    }

    public VoxelShape func_215664_b(FluidState fluidState, IBlockReader world, BlockPos pos) {
        return this.shapeMap.computeIfAbsent(fluidState, s -> VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)s.func_215679_a(world, pos), (double)1.0));
    }

    public static int ceilDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) >= 0 && r * y != x) {
            ++r;
        }
        return r;
    }
}

