/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion.entity;

import cofh.lib.entity.AbstractMinecartEntityCoFH;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.thermal.locomotion.init.TLocReferences;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class FluidMinecartEntity
extends AbstractMinecartEntityCoFH {
    public static final int BASE_CAPACITY = 64000;
    protected FluidStorageCoFH fluidStorage = new FluidStorageCoFH(64000);
    protected LazyOptional<?> fluidCap = LazyOptional.empty();

    public FluidMinecartEntity(EntityType<? extends FluidMinecartEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public FluidMinecartEntity(World worldIn, double posX, double posY, double posZ) {
        super(TLocReferences.FLUID_CART_ENTITY, worldIn, posX, posY, posZ);
    }

    public FluidMinecartEntity onPlaced(ItemStack stack) {
        super.onPlaced(stack);
        Map enchantMap = EnchantmentHelper.func_226652_a_((ListNBT)this.enchantments);
        float holdingMod = this.getHoldingMod(enchantMap);
        this.fluidStorage.applyModifiers(holdingMod);
        if (stack.func_77978_p() != null) {
            this.fluidStorage.read(stack.func_77978_p());
        }
        return this;
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        this.fluidStorage.write(stack.func_77978_p());
        return super.createItemStackTag(stack);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        Map enchantMap = EnchantmentHelper.func_226652_a_((ListNBT)this.enchantments);
        float holdingMod = this.getHoldingMod(enchantMap);
        this.fluidStorage.applyModifiers(holdingMod);
        this.fluidStorage.read(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.fluidStorage.write(compound);
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)TLocReferences.FLUID_CART_ITEM);
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.CHEST;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.fluidCap.isPresent() && this.fluidStorage.getCapacity() > 0) {
                this.fluidCap = LazyOptional.of(() -> this.fluidStorage);
            }
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.fluidCap.invalidate();
    }
}

