/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.impl.discord.ArgumentType;
import forge.com.gitlab.cdagaming.craftpresence.utils.MappingUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public class BiomeUtils {
    private final List<ResourceLocation> BIOME_TYPES = Lists.newArrayList();
    private final String argumentFormat = "&BIOME&";
    private final String subArgumentFormat = "&BIOME:";
    private final List<Pair<String, String>> biomeArgs = Lists.newArrayList();
    private final List<Pair<String, String>> iconArgs = Lists.newArrayList();
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> BIOME_NAMES = Lists.newArrayList();
    private String CURRENT_BIOME_NAME;
    private String CURRENT_BIOME_IDENTIFIER;

    private void emptyData() {
        this.BIOME_NAMES.clear();
        this.BIOME_TYPES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_BIOME_NAME = null;
        this.CURRENT_BIOME_IDENTIFIER = null;
        this.biomeArgs.clear();
        this.iconArgs.clear();
        this.isInUse = false;
        CraftPresence.CLIENT.removeArgumentsMatching("&BIOME:");
        CraftPresence.CLIENT.initArgument("&BIOME&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.detectBiomeData : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.BIOME_NAMES.isEmpty() || this.BIOME_TYPES.isEmpty());
        if (needsUpdate) {
            this.getBiomes();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateBiomeData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else if (this.isInUse) {
            this.emptyData();
        }
    }

    private void updateBiomeData() {
        String newBiome_Identifier;
        String newBiomeName;
        Biome newBiome = CraftPresence.player.field_70170_p.func_226691_t_(CraftPresence.player.func_233580_cy_());
        ResourceLocation newIdentifier = CraftPresence.player.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)newBiome);
        String string = newIdentifier != null ? StringUtils.formatIdentifier(newIdentifier.toString(), false, !CraftPresence.CONFIG.formatWords) : (newBiomeName = "Plains");
        String newBiome_primaryIdentifier = newIdentifier != null ? StringUtils.formatIdentifier(newIdentifier.toString(), true, !CraftPresence.CONFIG.formatWords) : "plains";
        String newBiome_alternativeIdentifier = StringUtils.formatIdentifier(MappingUtils.getClassName(newBiome), true, !CraftPresence.CONFIG.formatWords);
        String string2 = newBiome_Identifier = !StringUtils.isNullOrEmpty(newBiome_primaryIdentifier) ? newBiome_primaryIdentifier : newBiome_alternativeIdentifier;
        if (!newBiomeName.equals(this.CURRENT_BIOME_NAME) || !newBiome_Identifier.equals(this.CURRENT_BIOME_IDENTIFIER)) {
            this.CURRENT_BIOME_NAME = !StringUtils.isNullOrEmpty(newBiomeName) ? newBiomeName : newBiome_Identifier;
            this.CURRENT_BIOME_IDENTIFIER = newBiome_Identifier;
            if (!this.BIOME_NAMES.contains(newBiome_Identifier)) {
                this.BIOME_NAMES.add(newBiome_Identifier);
            }
            if (!this.BIOME_TYPES.contains(newIdentifier)) {
                this.BIOME_TYPES.add(newIdentifier);
            }
            this.updateBiomePresence();
        }
    }

    public void updateBiomePresence() {
        this.biomeArgs.clear();
        this.iconArgs.clear();
        String defaultBiomeMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentBiomeMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, this.CURRENT_BIOME_IDENTIFIER, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultBiomeMessage);
        String currentBiomeIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.biomeMessages, this.CURRENT_BIOME_IDENTIFIER, 0, 2, CraftPresence.CONFIG.splitCharacter, this.CURRENT_BIOME_IDENTIFIER);
        String formattedIconKey = StringUtils.formatAsIcon(currentBiomeIcon.replace(" ", "_"));
        this.biomeArgs.add(new Pair<String, String>("&BIOME&", this.CURRENT_BIOME_NAME));
        this.iconArgs.add(new Pair<String, String>("&ICON&", CraftPresence.CONFIG.defaultBiomeIcon));
        for (Pair<String, String> argumentData : this.biomeArgs) {
            CraftPresence.CLIENT.syncArgument("&BIOME:" + argumentData.getFirst().substring(1), argumentData.getSecond(), ArgumentType.Text);
        }
        for (Pair<String, String> argumentData : this.iconArgs) {
            CraftPresence.CLIENT.syncArgument("&BIOME:" + argumentData.getFirst().substring(1), argumentData.getSecond(), ArgumentType.Image);
        }
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            StringUtils.addEntriesNotPresent(this.biomeArgs, CraftPresence.CLIENT.generalArgs);
        }
        String CURRENT_BIOME_ICON = StringUtils.sequentialReplaceAnyCase(formattedIconKey, this.iconArgs);
        String CURRENT_BIOME_MESSAGE = StringUtils.sequentialReplaceAnyCase(currentBiomeMessage, this.biomeArgs);
        CraftPresence.CLIENT.syncArgument("&BIOME&", CURRENT_BIOME_MESSAGE, ArgumentType.Text);
        CraftPresence.CLIENT.syncArgument("&BIOME&", CraftPresence.CLIENT.imageOf("&BIOME&", true, CURRENT_BIOME_ICON, CraftPresence.CONFIG.defaultBiomeIcon), ArgumentType.Image);
    }

    private List<ResourceLocation> getBiomeTypes() {
        ArrayList defaultBiomeTypes;
        ArrayList biomeTypes = Lists.newArrayList();
        Optional biomeRegistry = DynamicRegistries.func_239770_b_().func_230521_a_(Registry.field_239720_u_);
        if (biomeRegistry.isPresent() && !(defaultBiomeTypes = Lists.newArrayList((Iterable)((Registry)biomeRegistry.get()).func_148742_b())).isEmpty()) {
            for (ResourceLocation type : defaultBiomeTypes) {
                if (type == null) continue;
                biomeTypes.add(type);
            }
        }
        return biomeTypes;
    }

    public void getBiomes() {
        for (ResourceLocation TYPE : this.getBiomeTypes()) {
            if (TYPE == null) continue;
            String name = StringUtils.formatIdentifier(TYPE.toString(), true, !CraftPresence.CONFIG.formatWords);
            if (!this.BIOME_NAMES.contains(name)) {
                this.BIOME_NAMES.add(name);
            }
            if (this.BIOME_TYPES.contains(TYPE)) continue;
            this.BIOME_TYPES.add(TYPE);
        }
        for (String biomeMessage : CraftPresence.CONFIG.biomeMessages) {
            String name;
            String[] part;
            if (StringUtils.isNullOrEmpty(biomeMessage) || StringUtils.isNullOrEmpty((part = biomeMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.BIOME_NAMES.contains(name = StringUtils.formatIdentifier(part[0], true, !CraftPresence.CONFIG.formatWords))) continue;
            this.BIOME_NAMES.add(name);
        }
    }

    public String generateArgumentMessage(ArgumentType ... types) {
        types = types != null && types.length > 0 ? types : ArgumentType.values();
        HashMap argumentData = Maps.newHashMap();
        for (ArgumentType type : types) {
            ArrayList queuedEntries = Lists.newArrayList();
            if (type == ArgumentType.Image) {
                queuedEntries.add("&BIOME:ICON&");
            } else if (type == ArgumentType.Text) {
                queuedEntries.add("&BIOME:BIOME&");
            }
            argumentData.put(type, queuedEntries);
        }
        return CraftPresence.CLIENT.generateArgumentMessage("&BIOME&", "&BIOME:", argumentData);
    }
}

