/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.updater;

import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import forge.com.gitlab.cdagaming.craftpresence.utils.updater.ModUpdaterUtils;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;

public class UpdateInfoGui
extends ExtendedScreen {
    private final ModUpdaterUtils modUpdater;
    private ExtendedButtonControl downloadButton;
    private ExtendedButtonControl checkButton;

    public UpdateInfoGui(Screen parentScreen, ModUpdaterUtils modUpdater) {
        super(parentScreen);
        this.modUpdater = modUpdater;
    }

    @Override
    public void initializeUi() {
        this.checkButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 30, 180, 20, "gui.config.message.button.checkForUpdates", () -> this.modUpdater.checkForUpdates(() -> {
            if (this.modUpdater.isInvalidVersion) {
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_ID", "v" + this.modUpdater.targetVersion, -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_TYPE", this.modUpdater.currentState.getDisplayName(), -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_LABEL", this.modUpdater.currentState.getDisplayName(), -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("NAME", CraftPresence.class.getSimpleName(), -17));
                this.modUpdater.currentVersion = this.modUpdater.targetVersion;
                this.modUpdater.isInvalidVersion = false;
            }
        }), new String[0]));
        this.addControl(new ExtendedButtonControl(10, this.getScreenHeight() - 30, 95, 20, "gui.config.message.button.back", () -> CraftPresence.GUIS.openScreen(this.parentScreen), new String[0]));
        this.downloadButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 105, this.getScreenHeight() - 30, 95, 20, "gui.config.message.button.download", () -> UrlUtils.openUrl(this.modUpdater.downloadUrl), new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.downloadButton.setControlEnabled(this.modUpdater.currentState == ModUpdaterUtils.UpdateState.OUTDATED || this.modUpdater.currentState == ModUpdaterUtils.UpdateState.BETA_OUTDATED);
        this.checkButton.setControlEnabled(this.modUpdater.currentState != ModUpdaterUtils.UpdateState.PENDING);
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.changes", this.modUpdater.currentState.getDisplayName());
        List<String> notice = StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.changelog", this.modUpdater.targetVersion, this.modUpdater.targetChangelogData));
        this.renderString(mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(subTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(subTitle) / 2.0f, 20.0f, 0xFFFFFF);
        CraftPresence.GUIS.drawMultiLineString(notice, 10, 45, this, false);
    }

    @Override
    public void postRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.changes", this.modUpdater.currentState.getDisplayName());
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0, this.getStringWidth(mainTitle), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title", ModUtils.VERSION_ID, 2)), this, true);
        }
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(subTitle) / 2.0f, 20.0, this.getStringWidth(subTitle), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title.changes", ModUtils.MCVersion)), this, true);
        }
    }
}

