/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.updater;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import java.util.List;
import java.util.Map;

public class ModUpdaterUtils {
    private final List<String> latestVersionTags = Lists.newArrayList((Object[])new String[]{"latest", "beta", "alpha", "bleeding-edge", "unstable", "rc", "release-candidate"});
    private final List<String> recommendedVersionTags = Lists.newArrayList((Object[])new String[]{"recommended", "stable", "release"});
    public UpdateState currentState = UpdateState.PENDING;
    public String modID;
    public String updateUrl;
    public String downloadUrl;
    public String targetLatestVersion;
    public String targetRecommendedVersion;
    public String targetVersion;
    public String targetChangelogData;
    public String currentVersion;
    public String currentGameVersion;
    public boolean isInvalidVersion = false;

    public ModUpdaterUtils(String modID, String updateUrl, String currentVersion, String currentGameVersion) {
        this.modID = modID;
        this.updateUrl = updateUrl;
        this.currentGameVersion = currentGameVersion;
        this.currentVersion = currentVersion.replaceAll("[a-zA-Z]", "").replace("\"", "").trim();
        if (currentVersion.contains("@")) {
            ModUtils.LOG.warn(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.updater.data.missing", modID), new Object[0]);
            this.currentVersion = "v0.0.0";
            this.isInvalidVersion = true;
        }
    }

    public void checkForUpdates() {
        this.checkForUpdates(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdates(Runnable callback) {
        this.currentState = UpdateState.PENDING;
        this.targetRecommendedVersion = "0.0.0";
        this.targetLatestVersion = "0.0.0";
        this.targetVersion = "0.0.0";
        this.targetChangelogData = "";
        this.downloadUrl = "";
        try {
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.updater.init", this.modID, this.currentGameVersion, this.updateUrl), new Object[0]);
            JsonObject rootUpdateData = FileUtils.parseJson(UrlUtils.getURLText(this.updateUrl, "UTF-8"));
            if (rootUpdateData != null) {
                ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.updater.receive.data", rootUpdateData.toString()), new Object[0]);
                if (rootUpdateData.has("homepage")) {
                    this.downloadUrl = rootUpdateData.get("homepage").toString().replace("\"", "").trim();
                } else {
                    ModUtils.LOG.warn(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.updater.homepage", new Object[0]), new Object[0]);
                }
                if (rootUpdateData.has("promos")) {
                    JsonObject mcVersionData;
                    JsonObject promoData = rootUpdateData.get("promos").getAsJsonObject();
                    for (Map.Entry jsonSegment : promoData.entrySet()) {
                        if (((String)jsonSegment.getKey()).contains("-")) {
                            String[] splitPromo = ((String)jsonSegment.getKey()).split("-");
                            String mcVersion = splitPromo[0];
                            if (!mcVersion.equalsIgnoreCase(this.currentGameVersion)) continue;
                            String dataTag = splitPromo[1];
                            if (this.latestVersionTags.contains(dataTag.toLowerCase())) {
                                this.targetLatestVersion = ((JsonElement)jsonSegment.getValue()).toString().replaceAll("[a-zA-Z]", "").replace("\"", "").trim();
                            } else if (this.recommendedVersionTags.contains(dataTag.toLowerCase())) {
                                this.targetRecommendedVersion = ((JsonElement)jsonSegment.getValue()).toString().replaceAll("[a-zA-Z]", "").replace("\"", "").trim();
                            }
                            if (this.targetLatestVersion.equalsIgnoreCase("0.0.0") || this.targetRecommendedVersion.equalsIgnoreCase("0.0.0")) continue;
                            break;
                        }
                        if (((String)jsonSegment.getKey()).equalsIgnoreCase(this.currentGameVersion)) {
                            this.targetRecommendedVersion = ((JsonElement)jsonSegment.getValue()).toString().replaceAll("[a-zA-Z]", "").replace("\"", "").trim();
                            continue;
                        }
                        ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.updater.incompatible.json", jsonSegment.getKey()), new Object[0]);
                    }
                    ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.updater.status", "Latest", this.currentGameVersion, this.targetLatestVersion), new Object[0]);
                    ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.updater.status", "Recommended", this.currentGameVersion, this.targetRecommendedVersion), new Object[0]);
                    if (this.isInvalidVersion) {
                        this.currentVersion = this.targetRecommendedVersion;
                    }
                    int recommendedState = this.compareVersions(this.currentVersion, this.targetRecommendedVersion);
                    int latestState = this.compareVersions(this.currentVersion, this.targetLatestVersion);
                    if (recommendedState == 0) {
                        this.currentState = UpdateState.UP_TO_DATE;
                        this.targetVersion = this.targetRecommendedVersion;
                    } else if (recommendedState == -1) {
                        this.currentState = UpdateState.OUTDATED;
                        this.targetVersion = this.targetRecommendedVersion;
                    } else {
                        this.currentState = latestState == 0 || latestState == 1 ? UpdateState.BETA : UpdateState.BETA_OUTDATED;
                        this.targetVersion = this.targetLatestVersion;
                    }
                    ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.updater.receive.status", this.modID, this.currentState.getDisplayName(), this.targetVersion), new Object[0]);
                    if (rootUpdateData.has(this.currentGameVersion) && (mcVersionData = rootUpdateData.get(this.currentGameVersion).getAsJsonObject()) != null) {
                        JsonElement annotatedVersionData;
                        JsonElement semanticVersionData = mcVersionData.has(this.targetVersion) ? mcVersionData.get(this.targetVersion) : null;
                        JsonElement jsonElement = annotatedVersionData = mcVersionData.has("v" + this.targetVersion) ? mcVersionData.get("v" + this.targetVersion) : null;
                        if (semanticVersionData != null || annotatedVersionData != null) {
                            JsonElement changelogData = semanticVersionData != null ? semanticVersionData : annotatedVersionData;
                            this.targetChangelogData = changelogData.toString().replace("\"", "").trim();
                            ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.updater.receive.changelog", this.targetChangelogData), new Object[0]);
                        } else {
                            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.updater.changelog", this.modID, this.targetVersion), new Object[0]);
                        }
                    }
                }
            }
        }
        catch (Error | Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.updater.failed", new Object[0]), new Object[0]);
            if (ModUtils.IS_DEV) {
                ex.printStackTrace();
            }
            this.currentState = UpdateState.FAILED;
        }
        finally {
            if (callback != null) {
                callback.run();
            }
        }
    }

    private int compareVersions(String version1, String version2) {
        int i;
        if (version1.equals(version2)) {
            return 0;
        }
        String[] versionSet1 = version1.split("\\.");
        String[] versionSet2 = version2.split("\\.");
        for (i = 0; i < versionSet1.length && i < versionSet2.length && versionSet1[i].equals(versionSet2[i]); ++i) {
        }
        if (i < versionSet1.length && i < versionSet2.length) {
            return Integer.valueOf(versionSet1[i]).compareTo(Integer.valueOf(versionSet2[i]));
        }
        if (i < versionSet1.length) {
            boolean allZeros = true;
            int j = i;
            while (allZeros & j < versionSet1.length) {
                allZeros = Integer.parseInt(versionSet1[j]) == 0;
                ++j;
            }
            return allZeros ? 0 : -1;
        }
        if (i < versionSet2.length) {
            boolean allZeros = true;
            int j = i;
            while (allZeros & j < versionSet2.length) {
                allZeros = Integer.parseInt(versionSet2[j]) == 0;
                ++j;
            }
            return allZeros ? 0 : 1;
        }
        return 0;
    }

    public static enum UpdateState {
        FAILED,
        UP_TO_DATE("Release"),
        OUTDATED,
        BETA_OUTDATED("Beta (Outdated)"),
        BETA,
        PENDING;

        final String displayName;

        private UpdateState() {
            this.displayName = StringUtils.formatWord(this.name().toLowerCase());
        }

        private UpdateState(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

