/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ExtendedScreen
extends Screen {
    public final Screen parentScreen;
    public final Screen currentScreen;
    protected final List<IGuiEventListener> extendedControls = Lists.newArrayList();
    protected final List<ScrollableListControl> extendedLists = Lists.newArrayList();
    protected MatrixStack currentMatrix = new MatrixStack();
    private boolean initialized = false;
    private boolean debugMode = false;
    private boolean verboseMode = false;
    private int lastMouseX = 0;
    private int lastMouseY = 0;

    public ExtendedScreen(Screen parentScreen) {
        super((ITextComponent)new StringTextComponent(""));
        this.field_230706_i_ = CraftPresence.instance;
        this.currentScreen = this;
        this.parentScreen = parentScreen;
        this.setDebugMode(ModUtils.IS_DEV);
        this.setVerboseMode(ModUtils.IS_VERBOSE);
    }

    public ExtendedScreen(Screen parentScreen, boolean debugMode) {
        this(parentScreen);
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(Screen parentScreen, boolean debugMode, boolean verboseMode) {
        this(parentScreen, debugMode);
        this.setVerboseMode(verboseMode);
    }

    public void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.extendedControls.clear();
        this.extendedLists.clear();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.initializeUi();
        super.func_231160_c_();
        this.initialized = true;
    }

    public void initializeUi() {
    }

    public void func_231152_a_(@Nonnull Minecraft mcIn, int w, int h) {
        this.initialized = false;
        super.func_231152_a_(mcIn, w, h);
    }

    @Nonnull
    protected <T extends Widget> T func_230480_a_(@Nonnull T buttonIn) {
        return this.addControl(buttonIn);
    }

    @Nonnull
    protected <T extends IGuiEventListener> T addControl(@Nonnull T buttonIn) {
        if (buttonIn instanceof Widget && !this.field_230710_m_.contains(buttonIn)) {
            this.field_230710_m_.add((Widget)buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    protected <T extends ScrollableListControl> T addList(@Nonnull T buttonIn) {
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        CraftPresence.GUIS.drawBackground(this.getScreenWidth(), this.getScreenHeight());
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentMatrix = matrixStack;
        if (this.initialized) {
            this.renderCriticalData();
            this.preRender();
            for (ScrollableListControl listControl : this.extendedLists) {
                if (!listControl.isVisible()) continue;
                listControl.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
            for (IGuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            for (IGuiEventListener extendedControl : this.extendedControls) {
                ExtendedButtonControl extendedButton;
                if (!(extendedControl instanceof ExtendedButtonControl) || !CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, extendedButton = (ExtendedButtonControl)extendedControl)) continue;
                extendedButton.onHover();
            }
            this.postRender();
        }
    }

    public boolean func_231046_a_(int keyCode, int mouseX, int mouseY) {
        if (this.initialized) {
            if (keyCode == 256) {
                CraftPresence.GUIS.openScreen(this.parentScreen);
                return true;
            }
            for (IGuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.func_231046_a_(keyCode, mouseX, mouseY);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_231046_a_(keyCode, mouseX, mouseY);
            }
        }
        return super.func_231046_a_(keyCode, mouseX, mouseY);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.func_231042_a_(typedChar, keyCode);
            }
            for (IGuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.func_231042_a_(typedChar, keyCode);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_231042_a_(typedChar, keyCode);
            }
        }
        return super.func_231042_a_(typedChar, keyCode);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.func_231044_a_(mouseX, mouseY, mouseButton);
            }
            for (IGuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.func_231044_a_(mouseX, mouseY, mouseButton);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_231044_a_(mouseX, mouseY, mouseButton);
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollAmount) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.func_231043_a_(mouseX, mouseY, scrollAmount);
            }
            for (IGuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.func_231043_a_(mouseX, mouseY, scrollAmount);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_231043_a_(mouseX, mouseY, scrollAmount);
            }
        }
        return super.func_231043_a_(mouseX, mouseY, scrollAmount);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double scrollX, double scrollY) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.func_231045_a_(mouseX, mouseY, mouseButton, scrollX, scrollY);
            }
            for (IGuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.func_231045_a_(mouseX, mouseY, mouseButton, scrollX, scrollY);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_231045_a_(mouseX, mouseY, mouseButton, scrollX, scrollY);
            }
        }
        return super.func_231045_a_(mouseX, mouseY, mouseButton, scrollX, scrollY);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (this.initialized) {
            for (ScrollableListControl listControl : this.extendedLists) {
                listControl.func_231048_c_(mouseX, mouseY, mouseButton);
            }
            for (IGuiEventListener extendedControl : this.extendedControls) {
                if (extendedControl instanceof ExtendedButtonControl) {
                    ExtendedButtonControl button = (ExtendedButtonControl)extendedControl;
                    button.func_231048_c_(mouseX, mouseY, mouseButton);
                }
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_231048_c_(mouseX, mouseY, mouseButton);
            }
        }
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public void func_231023_e_() {
        if (this.initialized) {
            for (IGuiEventListener extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_146178_a();
            }
        }
    }

    public boolean func_231178_ax__() {
        return false;
    }

    public void func_231164_f_() {
        this.initialized = false;
        CraftPresence.GUIS.resetIndex();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void renderNotice(List<String> notice) {
        this.renderNotice(notice, 2.0f, 3.0f, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale) {
        this.renderNotice(notice, widthScale, heightScale, false, false);
    }

    public void renderNotice(List<String> notice, float widthScale, float heightScale, boolean useXAsActual, boolean useYAsActual) {
        if (notice != null && !notice.isEmpty()) {
            for (int i = 0; i < notice.size(); ++i) {
                String string = notice.get(i);
                this.renderString(string, (useXAsActual ? widthScale : (float)this.getScreenWidth() / widthScale) - (float)this.getStringWidth(string) / widthScale, (useYAsActual ? heightScale : (float)this.getScreenHeight() / heightScale) + (float)(i * 10), 0xFFFFFF);
            }
        }
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.getFontRenderer().func_238405_a_(this.currentMatrix, text, xPos, yPos, color);
    }

    public int getStringWidth(String string) {
        return this.getFontRenderer().func_78256_a(string);
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public int getScreenWidth() {
        return this.field_230708_k_;
    }

    public int getScreenHeight() {
        return this.field_230709_l_;
    }

    public FontRenderer getFontRenderer() {
        return this.field_230706_i_.field_71466_p != null ? this.field_230706_i_.field_71466_p : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.debugMode = isDebugMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean isVerboseMode) {
        this.verboseMode = isVerboseMode;
    }
}

